/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.cubeswithoutborders.client.compat.sodium;

import dev.kir.cubeswithoutborders.client.FullscreenManager;
import dev.kir.cubeswithoutborders.client.FullscreenMode;
import dev.kir.cubeswithoutborders.client.config.CubesWithoutBordersConfig;
import java.util.Optional;
import java.util.Set;
import net.caffeinemc.mods.sodium.api.config.ConfigEntryPoint;
import net.caffeinemc.mods.sodium.api.config.ConfigEntryPointForge;
import net.caffeinemc.mods.sodium.api.config.option.SteppedValidator;
import net.caffeinemc.mods.sodium.api.config.structure.ConfigBuilder;
import net.caffeinemc.mods.sodium.api.config.structure.OptionBuilder;
import net.caffeinemc.mods.sodium.client.gui.FullscreenResolutionRange;
import net.minecraft.class_1041;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_313;

@ConfigEntryPointForge(value="cubes_without_borders")
public class SodiumCompat
implements ConfigEntryPoint {
    private static final class_2960 SODIUM_FULLSCREEN_ID = class_2960.method_60655((String)"sodium", (String)"general.fullscreen");
    private static final class_2960 SODIUM_FULLSCREEN_RESOLUTION_ID = class_2960.method_60655((String)"sodium", (String)"general.fullscreen_resolution");
    private static final class_2960 CWB_FULLSCREEN_ID = class_2960.method_60655((String)"cubes-without-borders", (String)"general.fullscreen");

    public void registerConfigLate(ConfigBuilder builder) {
        FullscreenManager fullscreenManager = FullscreenManager.getInstance();
        CubesWithoutBordersConfig config = CubesWithoutBordersConfig.getInstance();
        builder.registerOwnModOptions().registerOptionOverlay(SODIUM_FULLSCREEN_RESOLUTION_ID, (OptionBuilder)builder.createIntegerOption(SODIUM_FULLSCREEN_RESOLUTION_ID).setStorageHandler(() -> class_310.method_1551().field_1690.method_1640()).setName((class_2561)class_2561.method_43471((String)"options.fullscreen.resolution")).setTooltip((class_2561)class_2561.method_43471((String)"sodium.options.fullscreen_resolution.tooltip")).setValueFormatter(value -> {
            class_313 monitor = class_310.method_1551().method_22683().method_20831();
            if (monitor == null || value == 0) {
                return class_2561.method_43471((String)"options.fullscreen.current");
            }
            return class_2561.method_43470((String)monitor.method_1620(Math.min(value - 1, monitor.method_1621() - 1)).toString().replace(" (24bit)", ""));
        }).setValidator((SteppedValidator)new FullscreenResolutionRange()).setDefaultValue(Integer.valueOf(0)).setBinding(value -> {
            class_1041 window = class_310.method_1551().method_22683();
            if (window == null) {
                return;
            }
            class_313 monitor = window.method_20831();
            if (monitor == null) {
                return;
            }
            window.method_4505(value == 0 ? Optional.empty() : Optional.of(monitor.method_1620(value - 1)));
            window.method_4475();
        }, () -> {
            class_1041 window = class_310.method_1551().method_22683();
            if (window == null) {
                return 0;
            }
            class_313 monitor = window.method_20831();
            if (monitor == null) {
                return 0;
            }
            Optional optional = window.method_4511();
            return optional.map(v -> monitor.method_1619(v) + 1).orElse(0);
        }).setEnabledProvider(state -> {
            class_1041 window = class_310.method_1551().method_22683();
            if (window == null) {
                return false;
            }
            class_313 monitor = window.method_20831();
            return monitor != null && monitor.method_1621() > 0;
        }, new class_2960[]{CWB_FULLSCREEN_ID})).registerOptionReplacement(SODIUM_FULLSCREEN_ID, (OptionBuilder)builder.createEnumOption(CWB_FULLSCREEN_ID, FullscreenMode.class).setStorageHandler(config::save).setName((class_2561)class_2561.method_43471((String)"options.fullscreen")).setTooltip((class_2561)class_2561.method_43471((String)"sodium.options.fullscreen.tooltip")).setDefaultValue((Enum)FullscreenMode.OFF).setBinding(fullscreenManager::setFullscreenMode, fullscreenManager::getFullscreenMode).setAllowedValuesProvider(__ -> {
            if (config.getBorderlessFullscreenType() == config.getFullscreenType()) {
                return Set.of(FullscreenMode.OFF, FullscreenMode.ON);
            }
            return Set.of(FullscreenMode.OFF, FullscreenMode.ON, FullscreenMode.BORDERLESS);
        }, new class_2960[0]).setElementNameProvider(mode -> class_2561.method_43471((String)mode.getTranslationKey())));
    }
}

