/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.utils;

import dev.isxander.controlify.utils.CUtil;

public enum Platform {
    UNKNOWN,
    MAC,
    LINUX,
    WINDOWS,
    ANDROID,
    IOS;

    private static final Platform currentPlatform;

    public static Platform current() {
        return currentPlatform;
    }

    static {
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Linux")) {
            currentPlatform = "dalvik".equalsIgnoreCase(System.getProperty("java.vm.name")) ? ANDROID : LINUX;
        } else if (osName.startsWith("Mac") || osName.startsWith("Darwin")) {
            currentPlatform = MAC;
        } else if (osName.startsWith("Windows")) {
            currentPlatform = WINDOWS;
        } else if (osName.startsWith("iOS")) {
            currentPlatform = IOS;
        } else {
            CUtil.LOGGER.log("Unable to determine platform: " + osName);
            currentPlatform = UNKNOWN;
        }
    }
}

