/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.utils.animation.impl;

import dev.isxander.controlify.utils.animation.api.Animatable;
import dev.isxander.controlify.utils.animation.api.AnimationGroup;
import dev.isxander.controlify.utils.animation.impl.Animator;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.Validate;

public class AnimationGroupImpl
implements AnimationGroup {
    private final Set<Animatable> animatables = new ObjectArraySet();
    private boolean started;
    private boolean done;

    @Override
    public AnimationGroup add(Animatable ... animation) {
        Validate.isTrue((!this.hasStarted() ? 1 : 0) != 0, (String)"Cannot add to group that has already started.", (Object[])new Object[0]);
        for (Animatable animatable : animation) {
            Validate.isTrue((!animatable.hasStarted() ? 1 : 0) != 0, (String)"Cannot add an animation that has already started!", (Object[])new Object[0]);
        }
        this.animatables.addAll(List.of(animation));
        return this;
    }

    @Override
    public void tick(float tickDelta) {
        if (this.done) {
            return;
        }
        this.started = true;
        this.done = !this.animatables.stream().noneMatch(animatable -> {
            animatable.tick(tickDelta);
            return animatable.isDone();
        });
    }

    @Override
    public void skipToEnd() {
        this.animatables.forEach(Animatable::skipToEnd);
        this.done = true;
        this.started = true;
    }

    @Override
    public void abort() {
        this.animatables.forEach(Animatable::abort);
        this.done = true;
        this.started = true;
    }

    @Override
    public boolean hasStarted() {
        return this.started;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public boolean isPlaying() {
        return this.started && !this.done;
    }

    @Override
    public AnimationGroup play() {
        Animator.INSTANCE.add(this);
        return this;
    }

    @Override
    public AnimationGroup copy() {
        AnimationGroup group = AnimationGroup.of();
        this.animatables.forEach(animatable -> group.add(animatable.copy()));
        return group;
    }
}

