/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.utils.render.elements;

import dev.isxander.controlify.utils.render.BaseRenderState;
import dev.isxander.controlify.utils.render.CGuiElementRenderState;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4588;

public record CircleElementRenderState(BaseRenderState baseState, float originX, float originY, float radius, float thickness, int color, int segments) implements CGuiElementRenderState
{
    @Override
    public void buildVertices(class_4588 vertexConsumer, float z) {
        float innerRadius = this.radius - this.thickness;
        for (int i = 0; i < this.segments; ++i) {
            int j = (i + 1) % this.segments;
            float angle = (float)i / (float)this.segments * ((float)Math.PI * 2);
            float nextAngle = (float)j / (float)this.segments * ((float)Math.PI * 2);
            float xi1 = this.originX + class_3532.method_15374((double)angle) * innerRadius;
            float yi1 = this.originY + class_3532.method_15362((double)angle) * innerRadius;
            float xi2 = this.originX + class_3532.method_15374((double)nextAngle) * innerRadius;
            float yi2 = this.originY + class_3532.method_15362((double)nextAngle) * innerRadius;
            float xo1 = this.originX + class_3532.method_15374((double)angle) * this.radius;
            float yo1 = this.originY + class_3532.method_15362((double)angle) * this.radius;
            float xo2 = this.originX + class_3532.method_15374((double)nextAngle) * this.radius;
            float yo2 = this.originY + class_3532.method_15362((double)nextAngle) * this.radius;
            this.add2DVertex(vertexConsumer, xi1, yi1, z).method_39415(this.color);
            this.add2DVertex(vertexConsumer, xo1, yo1, z).method_39415(this.color);
            this.add2DVertex(vertexConsumer, xo2, yo2, z).method_39415(this.color);
            this.add2DVertex(vertexConsumer, xi2, yi2, z).method_39415(this.color);
        }
    }

    public static CircleElementRenderState outline(class_332 graphics, float originX, float originY, float radius, float thickness, int color) {
        int minX = class_3532.method_15375((float)(originX - radius));
        int minY = class_3532.method_15375((float)(originY - radius));
        int maxX = class_3532.method_15386((float)(originX + radius));
        int maxY = class_3532.method_15386((float)(originY + radius));
        return new CircleElementRenderState(BaseRenderState.create(graphics, null, minX, minY, maxX, maxY), originX, originY, radius, thickness, color, CircleElementRenderState.segmentsForRadius(radius));
    }

    public static CircleElementRenderState filled(class_332 graphics, float originX, float originY, float radius, int color) {
        return CircleElementRenderState.outline(graphics, originX, originY, radius, radius, color);
    }

    private static int segmentsForRadius(float radius) {
        return class_3532.method_15384((double)(Math.PI * 2 * (double)radius / 4.0));
    }
}

