/*
 * Decompiled with CFR 0.152.
 */
package btw.lowercase.skyboxify.skybox;

import btw.lowercase.skyboxify.Skyboxify;
import btw.lowercase.skyboxify.skybox.Skybox;
import btw.lowercase.skyboxify.skybox.SkyboxSkyRenderer;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import org.jetbrains.annotations.NotNull;

public final class SkyboxManager {
    private static final List<Skybox> loadedSkyboxes = new ArrayList<Skybox>();
    private static final List<Skybox> activeSkyboxes = new LinkedList<Skybox>();

    public static void addSkybox(Skybox skybox) {
        Preconditions.checkNotNull((Object)skybox, (Object)"Skybox was null");
        loadedSkyboxes.add(skybox);
    }

    public static void clearSkyboxes() {
        class_310.method_1551().execute(SkyboxSkyRenderer.INSTANCE::clearCache);
        loadedSkyboxes.clear();
        activeSkyboxes.clear();
    }

    public static void tick(class_638 level) {
        if (Skyboxify.getConfig().enabled.isEnabled()) {
            for (Skybox skybox : loadedSkyboxes) {
                skybox.tick(level);
            }
            activeSkyboxes.removeIf(optiFineSkybox -> !optiFineSkybox.isActive());
            for (Skybox skybox : loadedSkyboxes) {
                if (activeSkyboxes.contains(skybox) || !skybox.isActive()) continue;
                activeSkyboxes.add(skybox);
            }
        }
    }

    public static boolean isEnabled(class_1937 level) {
        return Skyboxify.getConfig().enabled.isEnabled() && !activeSkyboxes.isEmpty() && level != null;
    }

    public static List<Skybox> getSkiesFor(class_5321<@NotNull class_1937> resourceKey) {
        return SkyboxManager.getActiveSkyboxes().stream().filter(skybox -> resourceKey.equals(skybox.getWorldKey())).toList();
    }

    public static boolean containsEnabled(class_5321<@NotNull class_1937> resourceKey) {
        return !SkyboxManager.getSkiesFor(resourceKey).isEmpty();
    }

    @Generated
    private SkyboxManager() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @Generated
    public static List<Skybox> getLoadedSkyboxes() {
        return loadedSkyboxes;
    }

    @Generated
    public static List<Skybox> getActiveSkyboxes() {
        return activeSkyboxes;
    }
}

