/*
 * Decompiled with CFR 0.152.
 */
package btw.lowercase.skyboxify.skybox;

import btw.lowercase.skyboxify.skybox.components.Range;
import btw.lowercase.skyboxify.utils.ParserCodecs;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JavaOps;
import com.mojang.serialization.JsonOps;
import java.util.List;
import java.util.Properties;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SkyboxParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(SkyboxParser.class);

    private SkyboxParser() {
    }

    @Nullable
    public static JsonObject parseSkyProperties(Properties properties, class_2960 propertiesIdentifier) {
        JsonObject output = new JsonObject();
        String source = properties.getProperty("source", null);
        if (source == null) {
            LOGGER.warn("Failed to load source texture \"{}\"", (Object)"No source provided or was null");
            return null;
        }
        DataResult sourceResult = ParserCodecs.getSourceTextureCodec(propertiesIdentifier).parse((DynamicOps)JavaOps.INSTANCE, (Object)source);
        if (sourceResult.isError()) {
            LOGGER.warn("{}", sourceResult.error().get());
            return null;
        }
        output.addProperty("source", ((class_2960)sourceResult.result().get()).toString());
        SkyboxParser.parseFade(properties, output);
        if (properties.containsKey("speed")) {
            float value = ParserCodecs.safeParseFloat(properties.getProperty("speed", null), 1.0f);
            if (value != Float.MIN_VALUE) {
                output.addProperty("speed", (Number)Float.valueOf(value));
            } else {
                LOGGER.warn("Invalid speed provided in skybox.");
            }
        }
        if (properties.containsKey("heights")) {
            SkyboxParser.parseHeights(properties.getProperty("heights"), output);
        }
        if (properties.containsKey("days")) {
            SkyboxParser.parseDaysLoop(properties.getProperty("days"), properties.getProperty("daysLoop", null), output);
        }
        if (properties.containsKey("blend")) {
            output.addProperty("blend", String.valueOf(properties.getProperty("blend")));
        }
        if (properties.containsKey("rotate")) {
            output.addProperty("rotate", Boolean.valueOf(Boolean.parseBoolean(properties.getProperty("rotate"))));
        }
        if (properties.containsKey("transition")) {
            output.addProperty("transition", (Number)Integer.parseInt(properties.getProperty("transition")));
        }
        if (properties.containsKey("axis")) {
            output.addProperty("axis", properties.getProperty("axis"));
        }
        if (properties.containsKey("weather")) {
            output.addProperty("weather", String.valueOf(properties.getProperty("weather")));
        }
        if (properties.containsKey("biomes")) {
            output.addProperty("biomes", String.valueOf(properties.getProperty("biomes")));
        }
        return output;
    }

    private static int toTickTime(String time) {
        String[] parts = time.trim().split(":");
        if (parts.length == 2) {
            int m = ParserCodecs.safeParseInteger(parts[1], -1);
            int h = ParserCodecs.safeParseInteger(parts[0], -1);
            if (h >= 0 && h <= 23 && m >= 0 && m <= 59) {
                if ((h -= 6) < 0) {
                    h += 24;
                }
                return h * 1000 + (int)((float)m / 60.0f * 1000.0f);
            }
        }
        LOGGER.warn("Invalid time: \"{}\" in skybox.", (Object)time);
        return -1;
    }

    private static void parseFade(Properties properties, JsonObject output) {
        JsonObject fade = new JsonObject();
        if (properties.containsKey("startFadeIn") && properties.containsKey("endFadeIn") && properties.containsKey("endFadeOut")) {
            int startFadeOut;
            int startFadeIn = SkyboxParser.toTickTime(properties.getProperty("startFadeIn"));
            int endFadeIn = SkyboxParser.toTickTime(properties.getProperty("endFadeIn"));
            int endFadeOut = SkyboxParser.toTickTime(properties.getProperty("endFadeOut"));
            if (properties.containsKey("startFadeOut")) {
                startFadeOut = SkyboxParser.toTickTime(properties.getProperty("startFadeOut"));
            } else {
                startFadeOut = endFadeOut - (endFadeIn - startFadeIn);
                if (startFadeIn <= startFadeOut && endFadeIn >= startFadeOut) {
                    startFadeOut = endFadeOut;
                }
            }
            fade.addProperty("startFadeIn", (Number)startFadeIn);
            fade.addProperty("endFadeIn", (Number)endFadeIn);
            fade.addProperty("startFadeOut", (Number)startFadeOut);
            fade.addProperty("endFadeOut", (Number)endFadeOut);
        } else {
            fade.addProperty("alwaysOn", Boolean.valueOf(true));
        }
        output.add("fade", (JsonElement)fade);
    }

    private static void parseDaysLoop(String days, String daysLoop, JsonObject output) {
        List rangeEntries = (List)ParserCodecs.getRangeEntriesCodec(false).orElse(List.of()).parse((DynamicOps)JavaOps.INSTANCE, (Object)days).getOrThrow();
        if (!rangeEntries.isEmpty()) {
            JsonObject loop = new JsonObject();
            loop.addProperty("days", (Number)(daysLoop == null ? 8 : ParserCodecs.safeParseInteger(daysLoop, 8)));
            JsonArray ranges = new JsonArray();
            rangeEntries.stream().map(range -> (JsonElement)Range.CODEC.encode(range, (DynamicOps)JsonOps.INSTANCE, (Object)new JsonObject()).getOrThrow()).forEach(arg_0 -> ((JsonArray)ranges).add(arg_0));
            loop.add("ranges", (JsonElement)ranges);
            output.add("loop", (JsonElement)loop);
        }
    }

    private static void parseHeights(String input, JsonObject output) {
        List rangeEntries = (List)ParserCodecs.getRangeEntriesCodec(true).orElse(List.of()).parse((DynamicOps)JavaOps.INSTANCE, (Object)input).getOrThrow();
        if (!rangeEntries.isEmpty()) {
            JsonArray heights = new JsonArray();
            rangeEntries.stream().map(range -> (JsonElement)Range.CODEC.encode(range, (DynamicOps)JsonOps.INSTANCE, (Object)new JsonObject()).getOrThrow()).forEach(arg_0 -> ((JsonArray)heights).add(arg_0));
            output.add("heights", (JsonElement)heights);
        }
    }
}

