/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone;

import com.google.common.base.Suppliers;
import com.mojang.blaze3d.pipeline.BlendFunction;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.platform.DestFactor;
import com.mojang.blaze3d.platform.SourceFactor;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.SequencedMap;
import java.util.function.Supplier;
import net.mehvahdjukaar.polytone.PlatStuff;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.content.particle.custom.render.ModelParticleRenderGroup;
import net.minecraft.class_10017;
import net.minecraft.class_1059;
import net.minecraft.class_10721;
import net.minecraft.class_10799;
import net.minecraft.class_12247;
import net.minecraft.class_1921;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3999;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_765;
import net.minecraft.class_9799;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class PolytoneRenderTypes {
    public static final class_3999 PARTICLE_MODEL_GROUP = new class_3999(Polytone.res("particle_model").toString());
    public static final class_10721 PARTICLES_MAPPER = new class_10721(class_1059.field_17898, "particle");
    private static final BlendFunction ADDITIVE_TRANSLUCENT_BLEND = new BlendFunction(SourceFactor.SRC_ALPHA, DestFactor.ONE);
    public static final RenderPipeline ADDITIVE_TRANSLUCENT_PARTICLE_PIPELINE = class_10799.method_67887((RenderPipeline)RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{class_10799.field_60127}).withLocation(Polytone.res("pipeline/additive_particle")).withSampler("Sampler0").withSampler("Sampler2").withVertexShader(class_2960.method_60656((String)"core/particle")).withFragmentShader(Polytone.res("core/particle_no_cutoff")).withVertexFormat(class_290.field_1584, VertexFormat.class_5596.field_27382).withDepthWrite(false).withCull(true).withBlend(ADDITIVE_TRANSLUCENT_BLEND).build());
    public static final class_1921 ADDITIVE_TRANSLUCENT_PARTICLE_RENDERTYPE = class_1921.method_75940((String)"polytone:additive_particle", (class_12247)class_12247.method_75927((RenderPipeline)ADDITIVE_TRANSLUCENT_PARTICLE_PIPELINE).method_75929(65536).method_75928().method_75934("Sampler0", PARTICLES_MAPPER.comp_3608()).method_75932(class_12247.class_4750.field_21853).method_75937().method_75938());
    public static final Supplier<class_3999> PARTICLE_ADDITIVE_TRANSLUCENCY_RENDER_TYPE = Suppliers.memoize(() -> new class_3999("particle_additive_translucent"));
    public static final RenderPipeline ADDITIVE_TRANSLUCENT_BLOCK_PIPELINE = class_10799.method_67887((RenderPipeline)RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{class_10799.field_56853}).withShaderDefine("ALPHA_CUTOUT", 0.001f).withLocation(Polytone.res("pipeline/additive_block")).withBlend(ADDITIVE_TRANSLUCENT_BLEND).build());
    public static final class_1921 ADDITIVE_TRANSLUCENT_BLOCK_RENDERTYPE = class_1921.method_75940((String)"polytone:additive_block", (class_12247)class_12247.method_75927((RenderPipeline)ADDITIVE_TRANSLUCENT_BLOCK_PIPELINE).method_75929(65536).method_75936().method_75937().method_75928().method_75932(class_12247.class_4750.field_21853).method_75938());
    public static final RenderPipeline LEASH_PIPELINE = class_10799.method_67887((RenderPipeline)RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{class_10799.field_60127}).withLocation("polytone/pipeline/leash").withVertexShader("core/rendertype_text").withFragmentShader("core/rendertype_text").withSampler("Sampler2").withSampler("Sampler0").withCull(false).withVertexFormat(class_290.field_20888, VertexFormat.class_5596.field_27380).build());
    private static final class_2960 LEASH_TEXTURE = class_2960.method_60656((String)"textures/entity/lead.png");
    private static final class_1921 LEASH_RENDER_TYPE = class_1921.method_75940((String)"polytone_leash", (class_12247)class_12247.method_75927((RenderPipeline)LEASH_PIPELINE).method_75934("Sampler0", LEASH_TEXTURE).method_75928().method_75938());
    public static final DeferredBufferSource DEFERRED_BUFFER_SOURCE = new DeferredBufferSource();
    private static Matrix4f lastModelViewMatrix;

    public static void init() {
        PlatStuff.registerParticleGroup(e -> e.register(PARTICLE_MODEL_GROUP, ModelParticleRenderGroup::new));
    }

    private static boolean isLeashRenderOn() {
        return true;
    }

    public static class_4588 getLeashVertexConsumer(class_4597 multiBufferSource) {
        if (!PolytoneRenderTypes.isLeashRenderOn()) {
            return null;
        }
        return multiBufferSource.method_73477(LEASH_RENDER_TYPE);
    }

    public static boolean addLeashVertexPair(class_4588 vertexConsumer, Matrix4f matrix4f, float startX, float startY, float startZ, float yOffset, float dx, float dz, int index, boolean bl, class_10017.class_10018 leashState) {
        if (!PolytoneRenderTypes.isLeashRenderOn()) {
            return false;
        }
        float segment = (float)index / 24.0f;
        int blockLight = (int)class_3532.method_16439((float)segment, (float)leashState.field_53342, (float)leashState.field_53343);
        int skyLight = (int)class_3532.method_16439((float)segment, (float)leashState.field_53344, (float)leashState.field_53345);
        int light = class_765.method_23687((int)blockLight, (int)skyLight);
        float z = startX * segment;
        float aa = startY > 0.0f ? startY * segment * segment : startY - startY * (1.0f - segment) * (1.0f - segment);
        float ab = startZ * segment;
        float u1 = 0.0f;
        float u2 = 1.0f;
        vertexConsumer.method_22918((Matrix4fc)matrix4f, z - dx, aa, ab + dz).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_60803(light).method_22913(u1, segment);
        vertexConsumer.method_22918((Matrix4fc)matrix4f, z + dx, aa + yOffset, ab - dz).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_60803(light).method_22913(u2, segment);
        return true;
    }

    public static void onRenderLast() {
        if (lastModelViewMatrix != null) {
            Matrix4f last = new Matrix4f((Matrix4fc)RenderSystem.getModelViewMatrix());
            RenderSystem.getModelViewMatrix().set((Matrix4fc)lastModelViewMatrix);
            DEFERRED_BUFFER_SOURCE.endBatches();
            RenderSystem.getModelViewMatrix().set((Matrix4fc)last);
        } else {
            DEFERRED_BUFFER_SOURCE.endBatches();
        }
    }

    public static void cacheMatrices() {
        lastModelViewMatrix = new Matrix4f((Matrix4fc)RenderSystem.getModelViewMatrix());
    }

    public static class DeferredBufferSource
    extends class_4597.class_4598 {
        protected final Supplier<class_9799> bufferSupplier;
        private final Collection<class_1921> delayed = new HashSet<class_1921>();

        protected DeferredBufferSource() {
            this(() -> new class_9799(786432), new LinkedHashMap<class_1921, class_9799>());
        }

        protected DeferredBufferSource(Supplier<class_9799> bufferSupplier, SequencedMap<class_1921, class_9799> fixedBuffers) {
            super(bufferSupplier.get(), fixedBuffers);
            this.bufferSupplier = bufferSupplier;
        }

        public void endBatches() {
            this.method_22994(ADDITIVE_TRANSLUCENT_BLOCK_RENDERTYPE);
            this.method_22994(ADDITIVE_TRANSLUCENT_PARTICLE_RENDERTYPE);
            for (class_1921 type : this.delayed) {
                this.method_22994(type);
            }
        }

        @NotNull
        public class_4588 method_73477(@NotNull class_1921 renderType) {
            if (!this.field_20953.containsKey(renderType)) {
                this.field_20953.put(renderType, this.bufferSupplier.get());
                if (renderType != ADDITIVE_TRANSLUCENT_BLOCK_RENDERTYPE && renderType != ADDITIVE_TRANSLUCENT_PARTICLE_RENDERTYPE) {
                    this.delayed.add(renderType);
                }
            }
            return super.method_73477(renderType);
        }

        public void method_22994(@NotNull class_1921 renderType) {
            super.method_22994(renderType);
        }
    }
}

