/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.common;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Locale;
import net.mehvahdjukaar.polytone.mixins.accessor.BiomeAccessor;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;

public class ColorUtils {
    public static final Codec<Integer> RGBA_COLOR = Codec.either((Codec)Codec.INT, (Codec)Codec.STRING.flatXmap(s -> ColorUtils.parseHex(s, false), s -> ColorUtils.parseHex(s, false))).xmap(either -> (Integer)either.map(integer -> integer, s -> Integer.parseUnsignedInt(s, 16)), integer -> Either.right((Object)("#" + String.format("%08X", integer))));
    public static final Codec<Integer> COLOR = Codec.either((Codec)Codec.INT, (Codec)Codec.STRING.flatXmap(s -> ColorUtils.parseHex(s, true), s -> ColorUtils.parseHex(s, true))).xmap(e -> (Integer)e.map(i -> i, s -> Integer.parseUnsignedInt(s, 16)), i -> Either.right((Object)("#" + String.format("%08X", i))));

    private static DataResult<String> parseHex(String s, boolean fillAlphaFirst) {
        Object st = s;
        if (s.startsWith("0x")) {
            st = s.substring(2);
        } else if (s.startsWith("#")) {
            st = s.substring(1);
        }
        if (((String)st).length() > 8) {
            return DataResult.error(() -> "Invalid color format. Hex value must have up to 8 characters.");
        }
        try {
            Integer.parseUnsignedInt((String)st, 16);
            if (fillAlphaFirst && ((String)st).length() == 6) {
                st = "FF" + (String)st;
            }
            return DataResult.success((Object)((String)st).toUpperCase(Locale.ROOT));
        }
        catch (NumberFormatException e) {
            return DataResult.error(() -> "Invalid color format. Must be hexadecimal.");
        }
    }

    public static int pack(float ... components) {
        int n = (int)(components[0] * 255.0f) << 16;
        int o = (int)(components[1] * 255.0f) << 8;
        int p = (int)(components[2] * 255.0f);
        return n & 0xFF0000 | o & 0xFF00 | p & 0xFF;
    }

    public static float[] unpack(int value) {
        int n = (value & 0xFF0000) >> 16;
        int o = (value & 0xFF00) >> 8;
        int p = value & 0xFF;
        return new float[]{(float)n / 255.0f, (float)o / 255.0f, (float)p / 255.0f};
    }

    public static class_1959.class_5482 getClimateSettings(class_1937 level, class_2338 pos) {
        return ColorUtils.getClimateSettings((class_1959)level.method_23753(pos).comp_349());
    }

    public static class_1959.class_5482 getClimateSettings(class_1959 biome) {
        return ((BiomeAccessor)biome).getClimateSettings();
    }
}

