/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.common.attributes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.mehvahdjukaar.polytone.common.attributes.ExtendedAttributeMod;
import net.mehvahdjukaar.polytone.common.attributes.IExtendedEntry;
import net.minecraft.class_12192;
import net.minecraft.class_12197;
import net.minecraft.class_12199;
import net.minecraft.class_12206;
import net.minecraft.class_12212;
import net.minecraft.class_156;
import net.minecraft.class_3542;
import org.jetbrains.annotations.NotNull;
import org.jspecify.annotations.NonNull;

public class EnvironmentAttributeMapMod {
    private final Map<class_12197<?>, class_12199.class_12201<?, ?>> entriesToReplace;
    private final Set<class_12197<?>> entriesToRemove;
    public static final EnvironmentAttributeMapMod EMPTY = new EnvironmentAttributeMapMod(Map.of());
    public static final Codec<EnvironmentAttributeMapMod> CODEC = Codec.lazyInitialized(() -> {
        Codec mapCodec = Codec.dispatchedMap((Codec)class_12206.field_63763, (Function)class_156.method_34866(attr -> Codec.either(Removal.CODEC, EnvironmentAttributeMapMod.createEntryCodec(attr))));
        return mapCodec.xmap(EnvironmentAttributeMapMod::new, mod -> mod.entriesToReplace.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Either.right((Object)((class_12199.class_12201)e.getValue())))));
    });

    private static <Value, Argument> Codec<class_12199.class_12201<Value, Argument>> createEntryCodec(class_12197<Value> environmentAttribute) {
        class_12192 type = environmentAttribute.method_75647();
        Codec attributeModifierCodec = type.comp_5130();
        Codec ec = attributeModifierCodec.dispatch("modifier", class_12199.class_12201::comp_5141, class_156.method_34866(mod -> EnvironmentAttributeMapMod.createEntryCodec(environmentAttribute, mod)));
        Codec valueCodec = environmentAttribute.method_75651();
        Codec supplierCodec = ExtendedAttributeMod.addDynamicValueCodec(valueCodec, type);
        return Codec.either(supplierCodec, (Codec)ec).xmap(EnvironmentAttributeMapMod::valueOrModToEntry, EnvironmentAttributeMapMod::entryToValueOrMod);
    }

    @NotNull
    private static <Value, Argument> Either<Either<Argument, Supplier<Argument>>, class_12199.class_12201<Value, Argument>> entryToValueOrMod(class_12199.class_12201<Value, Argument> entry) {
        if (entry.comp_5141() == class_12212.method_75713()) {
            Either<Argument, Supplier<Argument>> valOrSup = EnvironmentAttributeMapMod.supplierFromEntry(entry);
            return Either.left(valOrSup);
        }
        return Either.right(entry);
    }

    @NotNull
    private static <Value, Argument> Either<Argument, Supplier<Argument>> supplierFromEntry(class_12199.class_12201<Value, Argument> entry) {
        Either valOrSup;
        Supplier argSupp = ((IExtendedEntry)entry).polytone$getArgumentSupplier();
        if (argSupp != null) {
            valOrSup = Either.right(argSupp);
        } else {
            Object arg = entry.comp_5140();
            valOrSup = Either.left((Object)arg);
        }
        return valOrSup;
    }

    private static <Value, Argument> class_12199.class_12201<Value, Argument> valueOrModToEntry(Either<Either<Argument, Supplier<Argument>>, class_12199.class_12201<Value, Argument>> either) {
        return (class_12199.class_12201)either.map(a -> EnvironmentAttributeMapMod.entryFromSupplier(a, class_12212.method_75713()), entry -> entry);
    }

    private static <Value, Argument> class_12199.class_12201<Value, Argument> entryFromSupplier(Either<Argument, Supplier<Argument>> valueOrSupplier, class_12212<Value, Argument> modifier) {
        return (class_12199.class_12201)valueOrSupplier.map(value -> new class_12199.class_12201(value, modifier), supplier -> {
            class_12199.class_12201 entry = new class_12199.class_12201(supplier.get(), modifier);
            ((IExtendedEntry)entry).polytone$setArgumentSupplier(supplier);
            return entry;
        });
    }

    private static <Value, Argument> MapCodec<class_12199.class_12201<Value, Argument>> createEntryCodec(class_12197<Value> environmentAttribute, class_12212<Value, Argument> attributeModifier) {
        return RecordCodecBuilder.mapCodec(instance -> {
            Codec argumentCodec = attributeModifier.argumentCodec(environmentAttribute);
            Codec argOrSupplier = ExtendedAttributeMod.addDynamicValueCodec(argumentCodec, environmentAttribute.method_75647());
            return instance.group((App)argOrSupplier.fieldOf("argument").forGetter(EnvironmentAttributeMapMod::supplierFromEntry)).apply((Applicative)instance, object -> EnvironmentAttributeMapMod.entryFromSupplier(object, attributeModifier));
        });
    }

    private EnvironmentAttributeMapMod(Map<class_12197<?>, Either<Removal, ? extends class_12199.class_12201<?, ?>>> entries) {
        this.entriesToReplace = entries.entrySet().stream().filter(e -> ((Either)e.getValue()).right().isPresent()).collect(Collectors.toMap(Map.Entry::getKey, e -> (class_12199.class_12201)((Either)e.getValue()).right().get()));
        this.entriesToRemove = entries.entrySet().stream().filter(e -> ((Either)e.getValue()).left().isPresent()).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    private EnvironmentAttributeMapMod(Map<class_12197<?>, class_12199.class_12201<?, ?>> entriesToAdd, Set<class_12197<?>> entriesToRemove) {
        this.entriesToReplace = entriesToAdd;
        this.entriesToRemove = entriesToRemove;
    }

    public class_12199 toVanilla() {
        class_12199.class_12200 builder = class_12199.method_75661();
        builder.field_63729.putAll(this.entriesToReplace);
        return builder.method_75672();
    }

    public boolean isEmpty() {
        return this.entriesToReplace.isEmpty() && this.entriesToRemove.isEmpty();
    }

    public static EnvironmentAttributeMapMod wrapVanilla(class_12199 attributes) {
        if (attributes == class_12199.field_63724) {
            return EMPTY;
        }
        return new EnvironmentAttributeMapMod(class_12199.method_75661().method_75675((class_12199)attributes).field_63729, Set.of());
    }

    public EnvironmentAttributeMapMod merge(EnvironmentAttributeMapMod newMod) {
        HashMap mergedEntriesToAdd = new HashMap(this.entriesToReplace);
        mergedEntriesToAdd.putAll(newMod.entriesToReplace);
        HashSet mergedEntriesToRemove = new HashSet(this.entriesToRemove);
        mergedEntriesToRemove.addAll(newMod.entriesToRemove);
        return new EnvironmentAttributeMapMod(mergedEntriesToAdd, mergedEntriesToRemove);
    }

    public class_12199 modify(class_12199 original) {
        if (this.isEmpty()) {
            return original;
        }
        class_12199.class_12200 builder = class_12199.method_75661();
        for (class_12197 key : original.method_75666()) {
            if (this.entriesToRemove.contains(key)) continue;
            builder.field_63729.put(key, original.method_75662(key));
        }
        builder.field_63729.putAll(this.entriesToReplace);
        return builder.method_75672();
    }

    private static enum Removal implements class_3542
    {
        UNIT;

        public static final Codec<Removal> CODEC;

        public @NonNull String method_15434() {
            return "REMOVE";
        }

        static {
            CODEC = class_3542.method_28140(Removal::values);
        }
    }
}

