/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.common.codec;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.util.Optional;
import net.mehvahdjukaar.polytone.Polytone;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7871;
import net.minecraft.class_7876;

public final class ForwardAwareRegistryFixedCodec<E>
implements Codec<Optional<class_6880<E>>> {
    private final class_5321<? extends class_2378<E>> registryKey;

    ForwardAwareRegistryFixedCodec(class_5321<? extends class_2378<E>> registryKey) {
        this.registryKey = registryKey;
    }

    public <T> DataResult<T> encode(Optional<class_6880<E>> opt, DynamicOps<T> ops, T value) {
        if (ops instanceof class_6903) {
            class_6903 registryOps = (class_6903)ops;
            Optional optional = registryOps.method_46628(this.registryKey);
            if (opt.isEmpty()) {
                return DataResult.success(value, (Lifecycle)Lifecycle.stable());
            }
            class_6880 holder = opt.get();
            if (optional.isPresent()) {
                if (!holder.method_46745((class_7876)optional.get())) {
                    return DataResult.error(() -> "Element " + String.valueOf(holder) + " is not valid in current registry set");
                }
                return (DataResult)holder.method_40229().map(resourceKey -> class_2960.field_25139.encode((Object)resourceKey.method_29177(), ops, value), object -> DataResult.error(() -> "Elements from registry " + String.valueOf(this.registryKey) + " can't be serialized to a value"));
            }
        }
        return DataResult.error(() -> "Can't access registry " + String.valueOf(this.registryKey));
    }

    public <T> DataResult<Pair<Optional<class_6880<E>>, T>> decode(DynamicOps<T> dynamicOps, T object) {
        class_6903 registryOps;
        Optional optional;
        if (dynamicOps instanceof class_6903 && (optional = (registryOps = (class_6903)dynamicOps).method_46634(this.registryKey)).isPresent()) {
            class_7871 registry = (class_7871)optional.get();
            return class_2960.field_25139.decode(dynamicOps, object).flatMap(pair -> {
                class_2960 resourceLocation = (class_2960)pair.getFirst();
                class_5321 resKey = class_5321.method_29179(this.registryKey, (class_2960)resourceLocation);
                Optional eReference = registry.method_46746(resKey);
                if (eReference.isPresent()) {
                    return DataResult.success((Object)eReference);
                }
                if (this.isBlacklisted(resourceLocation)) {
                    return DataResult.success(Optional.empty());
                }
                return DataResult.error(() -> "Failed to get element " + String.valueOf(resourceLocation));
            }).map(reference -> Pair.of((Object)reference, (Object)object)).setLifecycle(Lifecycle.stable());
        }
        return DataResult.error(() -> "Can't access registry " + String.valueOf(this.registryKey));
    }

    public String toString() {
        return "RegistryFixedCodec[" + String.valueOf(this.registryKey) + "]";
    }

    private boolean isBlacklisted(class_2960 id) {
        return Polytone.isFutureId(id);
    }
}

