/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.common.exp.impl;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import net.mehvahdjukaar.polytone.common.ClientFrameTicker;
import net.mehvahdjukaar.polytone.common.ColorUtils;
import net.mehvahdjukaar.polytone.common.exp.ExpressionUtils;
import net.mehvahdjukaar.polytone.common.exp.IExpression;
import net.mehvahdjukaar.polytone.common.exp.PolytoneExpression;
import net.mehvahdjukaar.polytone.common.expressions.ExpTicker;
import net.mehvahdjukaar.polytone.common.expressions.impl.IBlockExp;
import net.minecraft.class_1297;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4538;
import org.jetbrains.annotations.NotNull;

public class BlockContextExpression
extends PolytoneExpression
implements IBlockExp {
    public static final Codec<BlockContextExpression> CODEC = Codec.STRING.flatXmap(s -> {
        try {
            return DataResult.success((Object)new BlockContextExpression((String)s));
        }
        catch (Exception e) {
            return DataResult.error(() -> "Failed to parse expression:" + e.getMessage());
        }
    }, javaxExpression -> DataResult.success((Object)javaxExpression.getUnparsed()));
    private final boolean hasState;

    public BlockContextExpression(String unparsed) {
        this(unparsed, false);
    }

    public BlockContextExpression(String unparsed, boolean concurrent) {
        super(unparsed, concurrent);
        this.hasState = unparsed.contains("state_prop");
    }

    @Override
    protected BlockContextExpression createConcurrent() {
        return new BlockContextExpression(this.getUnparsed(), true);
    }

    @Override
    protected void buildFunctions(PolytoneExpression.FunBuilder builder) {
        super.buildFunctions(builder);
        builder.add(STATE_PROP);
        builder.add(STATE_PROP_INT);
    }

    @Override
    public double evaluate(class_4538 level, @NotNull class_2338 pos, class_2680 state) {
        class_1297 e;
        ExpressionUtils.seedRandom(state.method_26190(pos));
        IExpression.IVars vars = this.expression.varBuilder();
        if (this.hasPos) {
            vars.setVariable("POS_X", pos.method_10263());
            vars.setVariable("POS_Y", pos.method_10264());
            vars.setVariable("POS_Z", pos.method_10260());
        }
        if (this.hasTime) {
            vars.setVariable("TIME", ClientFrameTicker.getGameTime());
        }
        if (this.hasDayTime) {
            vars.setVariable("DAY_TIME", ClientFrameTicker.getDayTime());
        }
        if (this.hasSunTime) {
            vars.setVariable("SUN_TIME", ClientFrameTicker.getSunTime());
        }
        if (this.hasRain) {
            vars.setVariable("RAIN", ExpTicker.getRainAndThunder());
        }
        if (this.hasSeason) {
            vars.setVariable("SEASON", ExpTicker.getSeasonNumber());
        }
        if (this.hasSkyLight) {
            vars.setVariable("SKY_LIGHT", level.method_8314(class_1944.field_9284, pos));
        }
        if (this.hasBlockLight) {
            vars.setVariable("BLOCK_LIGHT", level.method_8314(class_1944.field_9282, pos));
        }
        if (this.hasTemperature) {
            vars.setVariable("TEMPERATURE", ColorUtils.getClimateSettings((class_1959)((class_1959)level.method_23753((class_2338)pos).comp_349())).comp_844);
        }
        if (this.hasDownfall) {
            vars.setVariable("DOWNFALL", ColorUtils.getClimateSettings((class_1959)((class_1959)level.method_23753((class_2338)pos).comp_349())).comp_846);
        }
        if (this.hasState) {
            STATE_HACK.set(state);
        }
        if (this.hasPlayer) {
            e = class_310.method_1551().method_1560();
            vars.setVariable("PLAYER_X", e.method_23317());
            vars.setVariable("PLAYER_Y", e.method_23318());
            vars.setVariable("PLAYER_Z", e.method_23321());
        }
        if (this.hasDistance) {
            e = class_310.method_1551().method_1560();
            double x = (double)pos.method_10263() - e.method_23317();
            double y = (double)pos.method_10264() - e.method_23318();
            double z = (double)pos.method_10260() - e.method_23321();
            vars.setVariable("DISTANCE_SQUARED", x * x + y * y + z * z);
        }
        if (this.hasPlayerSpeed) {
            vars.setVariable("PLAYER_SPEED_SQUARED", ClientFrameTicker.getPlayerSpeed());
        }
        if (this.hasRenderDistance) {
            vars.setVariable("RENDER_DISTANCE", ClientFrameTicker.getRenderDistance());
        }
        return this.expression.evaluate(vars);
    }
}

