/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.common.exp.impl;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import net.mehvahdjukaar.polytone.common.ClientFrameTicker;
import net.mehvahdjukaar.polytone.common.ColorUtils;
import net.mehvahdjukaar.polytone.common.exp.ExpressionUtils;
import net.mehvahdjukaar.polytone.common.exp.IExpression;
import net.mehvahdjukaar.polytone.common.exp.PolytoneExpression;
import net.mehvahdjukaar.polytone.common.expressions.ExpTicker;
import net.mehvahdjukaar.polytone.common.expressions.impl.IEntityExp;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_310;

public class EntityContextExpression
extends PolytoneExpression
implements IEntityExp {
    public static final Codec<EntityContextExpression> CODEC = Codec.STRING.flatXmap(s -> {
        try {
            return DataResult.success((Object)new EntityContextExpression((String)s));
        }
        catch (Exception e) {
            return DataResult.error(() -> "Failed to parse expression:" + e.getMessage());
        }
    }, javaxExpression -> DataResult.success((Object)javaxExpression.getUnparsed()));
    private final boolean hasState;

    public EntityContextExpression(String unparsed) {
        this(unparsed, false);
    }

    public EntityContextExpression(String unparsed, boolean concurrent) {
        super(unparsed, concurrent);
        this.hasState = unparsed.contains("state_prop");
    }

    @Override
    protected EntityContextExpression createConcurrent() {
        return new EntityContextExpression(this.getUnparsed(), true);
    }

    @Override
    protected void buildFunctions(PolytoneExpression.FunBuilder builder) {
        super.buildFunctions(builder);
        builder.add(STATE_PROP);
        builder.add(STATE_PROP_INT);
    }

    @Override
    public double evaluate(class_1297 entity) {
        class_1297 e;
        class_1937 level = entity.method_73183();
        class_243 pos = entity.method_73189();
        double entityTime = entity.field_6012;
        ExpressionUtils.randomizeRandom();
        IExpression.IVars vb = this.expression.varBuilder();
        if (this.hasPos) {
            vb.setVariable("POS_X", pos.field_1352);
            vb.setVariable("POS_Y", pos.field_1351);
            vb.setVariable("POS_Z", pos.field_1350);
        }
        class_2338 p = class_2338.method_49638((class_2374)pos);
        if (this.hasTime) {
            vb.setVariable("TIME", entityTime);
        }
        if (this.hasDayTime) {
            vb.setVariable("DAY_TIME", ClientFrameTicker.getDayTime());
        }
        if (this.hasSunTime) {
            vb.setVariable("SUN_TIME", ClientFrameTicker.getSunTime());
        }
        if (this.hasRain) {
            vb.setVariable("RAIN", ExpTicker.getRainAndThunder());
        }
        if (this.hasSeason) {
            vb.setVariable("SEASON", ExpTicker.getSeasonNumber());
        }
        if (this.hasSkyLight) {
            vb.setVariable("SKY_LIGHT", level.method_8314(class_1944.field_9284, p));
        }
        if (this.hasBlockLight) {
            vb.setVariable("BLOCK_LIGHT", level.method_8314(class_1944.field_9282, p));
        }
        if (this.hasTemperature) {
            vb.setVariable("TEMPERATURE", ColorUtils.getClimateSettings((class_1959)((class_1959)level.method_23753((class_2338)p).comp_349())).comp_844);
        }
        if (this.hasDownfall) {
            vb.setVariable("DOWNFALL", ColorUtils.getClimateSettings((class_1959)((class_1959)level.method_23753((class_2338)p).comp_349())).comp_846);
        }
        if (this.hasState) {
            STATE_HACK.set(level.method_8320(p));
        }
        if (this.hasPlayer) {
            e = class_310.method_1551().method_1560();
            vb.setVariable("PLAYER_X", e.method_23317());
            vb.setVariable("PLAYER_Y", e.method_23318());
            vb.setVariable("PLAYER_Z", e.method_23321());
        }
        if (this.hasDistance) {
            e = class_310.method_1551().method_1560();
            double x = pos.field_1352 - e.method_23317();
            double y = pos.field_1351 - e.method_23318();
            double z = pos.field_1350 - e.method_23321();
            vb.setVariable("DISTANCE_SQUARED", x * x + y * y + z * z);
        }
        if (this.hasPlayerSpeed) {
            vb.setVariable("PLAYER_SPEED_SQUARED", ClientFrameTicker.getPlayerSpeed());
        }
        if (this.hasRenderDistance) {
            vb.setVariable("RENDER_DISTANCE", ClientFrameTicker.getRenderDistance());
        }
        return this.expression.evaluate(vb);
    }
}

