/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.common.expressions;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.common.expressions.ExpMath;
import net.mehvahdjukaar.polytone.common.expressions.proxies.CameraProxy;
import net.mehvahdjukaar.polytone.common.expressions.proxies.GlobalProxy;
import net.mehvahdjukaar.polytone.common.expressions.proxies.PlayerProxy;
import net.mehvahdjukaar.polytone.common.expressions.proxies.RandomProxy;
import net.minecraft.class_12197;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jspecify.annotations.NonNull;
import org.mvel2.ParserContext;
import org.mvel2.util.MethodStub;

public class ExpUtils {
    private static final Map<String, String> RENAMES = Map.of("POS_X", "o.x", "POS_Y", "o.y", "POS_Z", "o.z", "TIME", "g.time", "RAND", "r.next()");
    private static final Map<String, Object> STATIC_GLOBALS = (Map)class_156.method_656(() -> {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.putAll(ExpUtils.getAllStaticFields(ExpMath.class));
        m.put("camera", CameraProxy.INSTANCE);
        m.put("c", CameraProxy.INSTANCE);
        m.put("global", GlobalProxy.INSTANCE);
        m.put("g", GlobalProxy.INSTANCE);
        m.put("player", PlayerProxy.INSTANCE);
        m.put("p", PlayerProxy.INSTANCE);
        return m;
    });

    public static String upgrade(String expr) {
        return expr;
    }

    public static void addCommonInputs(ParserContext ctx) {
        ctx.addInput("camera", CameraProxy.class);
        ctx.addInput("c", CameraProxy.class);
        ctx.addInput("global", GlobalProxy.class);
        ctx.addInput("g", GlobalProxy.class);
        ctx.addInput("p", PlayerProxy.class);
        ctx.addInput("player", PlayerProxy.class);
        ctx.addInput("r", RandomProxy.class);
        ctx.addInput("random", RandomProxy.class);
        ExpUtils.importStaticMethods(ctx, ExpMath.class);
    }

    public static void addCommonVars(Map<String, Object> vars) {
        vars.putAll(STATIC_GLOBALS);
        Polytone.GLOBAL_EXPRESSION.addValues(vars);
    }

    private static void importStaticMethods(ParserContext ctx, Class<?> clazz) {
        for (Method method : clazz.getMethods()) {
            if (!Modifier.isStatic(method.getModifiers()) || method.getDeclaringClass() != clazz) continue;
            ctx.addImport(method.getName(), new MethodStub(method));
        }
    }

    private static Map<String, Object> getAllStaticFields(Class<?> clazz) {
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        for (Field field : clazz.getFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || field.getDeclaringClass() != clazz) continue;
            try {
                fieldValues.put(field.getName(), field.get(null));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return fieldValues;
    }

    public static @NonNull class_12197<?> parseEnvAttr(String attributeName) {
        class_12197 attr = (class_12197)class_7923.field_63925.method_63535(class_2960.method_60654((String)attributeName));
        if (attr == null) {
            throw new IllegalArgumentException("Unknown environment attribute: " + attributeName);
        }
        return attr;
    }
}

