/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.common.expressions;

import java.io.Serializable;
import java.util.HashMap;
import net.objecthunter.exp4j.Expression;
import net.objecthunter.exp4j.ExpressionBuilder;
import net.objecthunter.exp4j.function.Function;
import org.mvel2.MVEL;

public class ExpressionBenchmark {
    public static void main(String[] args) throws Exception {
        String expr1 = "(a + b * c) / d - pow(e,f)";
        String expr2 = "sin(x) * cos(y) + log(z) - sqrt(w)";
        int iterations = 1000000;
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("a", 2.0);
        vars.put("b", 3.0);
        vars.put("c", 4.0);
        vars.put("d", 5.0);
        vars.put("e", 2.0);
        vars.put("f", 3.0);
        vars.put("x", 0.7853981633974483);
        vars.put("y", 1.0471975511965976);
        vars.put("z", Math.E);
        vars.put("w", 16.0);
        vars.put("sin", MVEL.getStaticMethod(Math.class, (String)"sin", (Class[])new Class[]{Double.TYPE}));
        vars.put("cos", MVEL.getStaticMethod(Math.class, (String)"cos", (Class[])new Class[]{Double.TYPE}));
        vars.put("log", MVEL.getStaticMethod(Math.class, (String)"log", (Class[])new Class[]{Double.TYPE}));
        vars.put("sqrt", MVEL.getStaticMethod(Math.class, (String)"sqrt", (Class[])new Class[]{Double.TYPE}));
        vars.put("pow", MVEL.getStaticMethod(Math.class, (String)"pow", (Class[])new Class[]{Double.TYPE, Double.TYPE}));
        Serializable compiledExpr1 = MVEL.compileExpression((String)expr1.replace("^", "pow"));
        Serializable compiledExpr2 = MVEL.compileExpression((String)expr2);
        long mvelStart = System.nanoTime();
        for (int i = 0; i < iterations; ++i) {
            MVEL.executeExpression((Object)compiledExpr1, vars);
            MVEL.executeExpression((Object)compiledExpr2, vars);
        }
        long mvelEnd = System.nanoTime();
        System.out.println("MVEL (precompiled) total time: " + (mvelEnd - mvelStart) / 1000000L + " ms");
        Function sinFunc = new Function("sin", 1){

            public double apply(double ... args) {
                return Math.sin(args[0]);
            }
        };
        Function cosFunc = new Function("cos", 1){

            public double apply(double ... args) {
                return Math.cos(args[0]);
            }
        };
        Function logFunc = new Function("log", 1){

            public double apply(double ... args) {
                return Math.log(args[0]);
            }
        };
        Function sqrtFunc = new Function("sqrt", 1){

            public double apply(double ... args) {
                return Math.sqrt(args[0]);
            }
        };
        Function powFunc = new Function("pow", 2){

            public double apply(double ... args) {
                return Math.pow(args[0], args[1]);
            }
        };
        Expression e1 = new ExpressionBuilder(expr1.replace("^", "pow")).variables(new String[]{"a", "b", "c", "d", "e", "f"}).function(powFunc).build().setVariable("a", 2.0).setVariable("b", 3.0).setVariable("c", 4.0).setVariable("d", 5.0).setVariable("e", 2.0).setVariable("f", 3.0);
        Expression e2 = new ExpressionBuilder(expr2).variables(new String[]{"x", "y", "z", "w"}).function(sinFunc).function(cosFunc).function(logFunc).function(sqrtFunc).build().setVariable("x", 0.7853981633974483).setVariable("y", 1.0471975511965976).setVariable("z", Math.E).setVariable("w", 16.0);
        long exp4jStart = System.nanoTime();
        for (int i = 0; i < iterations; ++i) {
            e1.evaluate();
            e2.evaluate();
        }
        long exp4jEnd = System.nanoTime();
        System.out.println("exp4j (with Math functions) total time: " + (exp4jEnd - exp4jStart) / 1000000L + " ms");
    }
}

