/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.common.expressions;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.io.Serializable;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import net.mehvahdjukaar.polytone.common.expressions.ExpUtils;
import net.mehvahdjukaar.polytone.common.expressions.PolyExp;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;

public final class PolyExpType<T extends PolyExp> {
    private final BiFunction<Serializable, String, T> constructor;
    private final ParserContext context;
    private final Codec<T> codec = Codec.STRING.flatXmap(this::create, exp -> DataResult.success((Object)"0"));

    public PolyExpType(Function<Serializable, T> constructor, Consumer<ParserContext> inputs) {
        this((Serializable expr, String str) -> (PolyExp)constructor.apply((Serializable)expr), inputs);
    }

    public PolyExpType(BiFunction<Serializable, String, T> constructor, Consumer<ParserContext> inputs) {
        this.constructor = constructor;
        this.context = new ParserContext();
        this.context.setStrongTyping(true);
        this.context.setStrictTypeEnforcement(true);
        inputs.accept(this.context);
    }

    public Codec<T> codec() {
        return this.codec;
    }

    public DataResult<T> create(String expressionStr) {
        try {
            expressionStr = ExpUtils.upgrade(expressionStr);
            Serializable expr = MVEL.compileExpression((String)expressionStr, (ParserContext)this.context);
            return DataResult.success((Object)((PolyExp)this.constructor.apply(expr, expressionStr)));
        }
        catch (Exception e) {
            return DataResult.error(() -> "Failed to compile expression: " + e.getMessage());
        }
    }
}

