/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.common.expressions.impl;

import com.mojang.serialization.Codec;
import net.mehvahdjukaar.polytone.common.ClientFrameTicker;
import net.mehvahdjukaar.polytone.common.ColorUtils;
import net.mehvahdjukaar.polytone.common.codec.CodecUtils;
import net.mehvahdjukaar.polytone.common.expressions.ExpTicker;
import net.mehvahdjukaar.polytone.common.expressions.impl.ColormapExp;
import net.mehvahdjukaar.polytone.common.struc.MapRegistry;
import net.mehvahdjukaar.polytone.content.biome.BiomeIdMapper;
import net.mehvahdjukaar.polytone.content.colormap.ColormapExpressionProvider;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IColormapExp {
    public static final MapRegistry<IColormapExp> BUILTIN_EXP = new MapRegistry("Colormap Number Providers");
    public static final Codec<IColormapExp> CODEC = Codec.lazyInitialized(() -> CodecUtils.referenceOrDirect(BUILTIN_EXP, CodecUtils.withAlternative(Codec.FLOAT.xmap(aDouble -> (a, b, c, d, e, f) -> aDouble.floatValue(), iBlockExp -> Float.valueOf(0.0f)), ColormapExpressionProvider.CODEC, ColormapExp.TYPE.codec()), true));
    public static final IColormapExp ZERO = BUILTIN_EXP.register("zero", new Const(0.0f));
    public static final IColormapExp ONE = BUILTIN_EXP.register("one", new Const(1.0f));
    public static final IColormapExp DAY_TIME = BUILTIN_EXP.register("day_time", (level, state, pos, biome, mapper, stack) -> (float)(1.0 - ClientFrameTicker.getDayTime() % 24000.0 / 24000.0));
    public static final IColormapExp TEMPERATURE = BUILTIN_EXP.register("temperature", new IColormapExp(){

        @Override
        public float evaluate(@Nullable class_1920 level, class_2680 state, @NotNull class_2338 pos, @Nullable class_1959 biome, @Nullable BiomeIdMapper mapper, @Nullable class_1799 stack) {
            return biome == null ? 0.0f : ColorUtils.getClimateSettings((class_1959)biome).comp_844;
        }

        @Override
        public boolean usesState() {
            return false;
        }
    });
    public static final IColormapExp LEGACY_TEMPERATURE = BUILTIN_EXP.register("legacy_temperature", new IColormapExp(){

        @Override
        public float evaluate(@Nullable class_1920 level, class_2680 state, @NotNull class_2338 pos, @Nullable class_1959 biome, @Nullable BiomeIdMapper mapper, @Nullable class_1799 stack) {
            return biome == null ? 0.0f : biome.method_21740(pos, class_310.method_1551().field_1687.method_8615());
        }

        @Override
        public boolean usesState() {
            return false;
        }
    });
    public static final IColormapExp DOWNFALL = BUILTIN_EXP.register("downfall", new IColormapExp(){

        @Override
        public float evaluate(@Nullable class_1920 level, class_2680 state, @NotNull class_2338 pos, @Nullable class_1959 biome, @Nullable BiomeIdMapper mapper, @Nullable class_1799 stack) {
            return biome == null ? 0.0f : ColorUtils.getClimateSettings((class_1959)biome).comp_846;
        }

        @Override
        public boolean usesState() {
            return false;
        }
    });
    public static final IColormapExp BIOME_ID = BUILTIN_EXP.register("biome_id", new IColormapExp(){

        @Override
        public float evaluate(@Nullable class_1920 level, @Nullable class_2680 state, @Nullable class_2338 pos, @Nullable class_1959 biome, @Nullable BiomeIdMapper mapper, @Nullable class_1799 stack) {
            if (biome == null) {
                return 0.0f;
            }
            return 1.0f - mapper.getIndex(biome);
        }

        @Override
        public boolean usesState() {
            return false;
        }
    });
    public static final IColormapExp Y_LEVEL = BUILTIN_EXP.register("y_level", new IColormapExp(){

        @Override
        public float evaluate(@Nullable class_1920 level, @Nullable class_2680 state, @Nullable class_2338 pos, @Nullable class_1959 biome, @Nullable BiomeIdMapper mapper, @Nullable class_1799 stack) {
            if (pos == null) {
                return 64.0f;
            }
            class_5819 rs = class_5819.method_43049((long)((long)pos.hashCode() * pos.method_10063()));
            float yVariance = 4.0f;
            float v = yVariance * (rs.method_43057() - 0.5f);
            return 1.0f - ((float)(pos.method_10264() + 64) + v) / 256.0f;
        }

        @Override
        public boolean usesBiome() {
            return false;
        }

        @Override
        public boolean usesState() {
            return false;
        }
    });
    public static final IColormapExp DAMAGE = BUILTIN_EXP.register("item_damage", new IColormapExp(){

        @Override
        public float evaluate(@Nullable class_1920 level, @Nullable class_2680 state, @Nullable class_2338 pos, @Nullable class_1959 biome, @Nullable BiomeIdMapper mapper, @Nullable class_1799 stack) {
            if (stack == null) {
                return 0.0f;
            }
            return 1.0f - (float)stack.method_7919() / (float)stack.method_7936();
        }

        @Override
        public boolean usesBiome() {
            return false;
        }

        @Override
        public boolean usesPos() {
            return false;
        }

        @Override
        public boolean usesState() {
            return false;
        }
    });
    public static final IColormapExp SEASON = BUILTIN_EXP.register("season", new IColormapExp(){

        @Override
        public float evaluate(@Nullable class_1920 level, @Nullable class_2680 state, @Nullable class_2338 pos, @Nullable class_1959 biome, @Nullable BiomeIdMapper mapper, @Nullable class_1799 stack) {
            return 1.0f - ExpTicker.getSeasonNumber();
        }

        @Override
        public boolean usesBiome() {
            return false;
        }

        @Override
        public boolean usesPos() {
            return false;
        }

        @Override
        public boolean usesState() {
            return false;
        }
    });

    public float evaluate(@Nullable class_1920 var1, @Nullable class_2680 var2, @Nullable class_2338 var3, @Nullable class_1959 var4, @Nullable BiomeIdMapper var5, @Nullable class_1799 var6);

    default public boolean usesBiome() {
        return true;
    }

    default public boolean usesPos() {
        return true;
    }

    default public boolean usesState() {
        return true;
    }

    default public IColormapExp createConcurrent() {
        return this;
    }

    public record Const(float c) implements IColormapExp
    {
        @Override
        public float evaluate(@Nullable class_1920 level, class_2680 state, @NotNull class_2338 pos, @Nullable class_1959 biome, @Nullable BiomeIdMapper mapper, @Nullable class_1799 stack) {
            return this.c;
        }

        @Override
        public boolean usesState() {
            return false;
        }

        @Override
        public boolean usesBiome() {
            return false;
        }

        @Override
        public boolean usesPos() {
            return false;
        }
    }
}

