/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.common.expressions.proxies;

import com.google.common.base.Preconditions;
import net.mehvahdjukaar.candlelight.api.BeanGettersAliases;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.common.ColorUtils;
import net.mehvahdjukaar.polytone.common.expressions.ExpUtils;
import net.mehvahdjukaar.polytone.content.biome.BiomeIdMapper;
import net.minecraft.class_12197;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4538;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.apache.commons.lang3.ClassUtils;
import org.jspecify.annotations.Nullable;

@BeanGettersAliases
public abstract class PositionalProxy {
    private class_2680 stateCache;
    private class_2586 beCache;
    private class_1959 biomeCache;
    private String biomeNameCache;
    private class_2338 posCache;
    private boolean inEnvironmentAttributeCall = false;

    public PositionalProxy(@Nullable class_2680 state, @Nullable class_1959 biome) {
        this.stateCache = state;
        this.biomeCache = biome;
    }

    public PositionalProxy(@Nullable class_2680 state) {
        this.stateCache = state;
    }

    public PositionalProxy() {
    }

    protected abstract @Nullable class_1920 getLevelInternal();

    protected abstract @Nullable class_2338 getPosInternal();

    private @Nullable class_2338 updatedPos() {
        class_2338 newPos = this.getPosInternal();
        if (newPos == this.posCache) {
            return this.posCache;
        }
        if (this.posCache == null || !this.posCache.equals((Object)newPos)) {
            this.posCache = newPos;
            this.stateCache = null;
            this.beCache = null;
            this.biomeCache = null;
            this.biomeNameCache = null;
        }
        return this.posCache;
    }

    protected class_2680 getStateInternal() {
        class_2338 pos = this.updatedPos();
        if (this.stateCache == null) {
            class_1920 l = this.getLevelInternal();
            this.stateCache = pos == null || l == null ? class_2246.field_10124.method_9564() : l.method_8320(pos);
        }
        return this.stateCache;
    }

    protected @Nullable class_1959 getBiomeInternal() {
        block2: {
            class_4538 lr;
            class_2338 blockPos;
            block4: {
                block3: {
                    blockPos = this.updatedPos();
                    if (this.biomeCache != null) break block2;
                    class_1920 l = this.getLevelInternal();
                    if (!(l instanceof class_4538)) break block3;
                    lr = (class_4538)l;
                    if (blockPos != null) break block4;
                }
                return null;
            }
            class_6880 holder = lr.method_23753(blockPos);
            this.biomeCache = (class_1959)holder.comp_349();
            this.biomeNameCache = holder.method_55840();
        }
        return this.biomeCache;
    }

    protected @Nullable class_2586 getBlockEntityInternal() {
        class_2338 blockPos = this.updatedPos();
        if (blockPos == null) {
            return null;
        }
        class_1920 l = this.getLevelInternal();
        if (l == null) {
            return null;
        }
        if (this.beCache == null && this.hasBlockEntity()) {
            this.beCache = l.method_8321(blockPos);
        }
        return this.beCache;
    }

    public String block() {
        return this.getStateInternal().method_41520().method_55840();
    }

    public String blockState() {
        return this.getStateInternal().toString();
    }

    public Object blockStateValue(Object input) {
        class_2769 property = this.getStateInternal().method_26204().method_9595().method_11663(input.toString());
        Comparable value = this.getStateInternal().method_11654(property);
        if (ClassUtils.isPrimitiveOrWrapper(value.getClass())) {
            return value;
        }
        return value.toString();
    }

    public String biome() {
        if (this.biomeNameCache == null) {
            if (this.biomeCache != null) {
                if (!(this.getLevelInternal() instanceof class_1937)) {
                    this.biomeNameCache = "plains";
                }
            } else {
                this.getBiomeInternal();
            }
        }
        return this.biomeNameCache;
    }

    public double biomeIndex() {
        return 1.0f - BiomeIdMapper.LEGACY.getIndex(this.getBiomeInternal());
    }

    public double biomeIndex(String biomeMapper) {
        BiomeIdMapper mapper = Polytone.BIOME_ID_MAPPERS.get(biomeMapper);
        if (mapper == null) {
            throw new IllegalArgumentException("Unknown biome mapper: " + biomeMapper);
        }
        return 1.0f - mapper.getIndex(this.getBiomeInternal());
    }

    public double temperature() {
        return ColorUtils.getClimateSettings((class_1959)this.getBiomeInternal()).comp_844;
    }

    public double downfall() {
        return ColorUtils.getClimateSettings((class_1959)this.getBiomeInternal()).comp_846;
    }

    public double skyLight() {
        class_2338 blockPos = this.updatedPos();
        class_1920 l = this.getLevelInternal();
        if (blockPos == null || l == null) {
            return 15.0;
        }
        return l.method_8314(class_1944.field_9284, blockPos);
    }

    public double blockLight() {
        class_2338 blockPos = this.updatedPos();
        class_1920 l = this.getLevelInternal();
        if (blockPos == null || l == null) {
            return 0.0;
        }
        return this.getLevelInternal().method_8314(class_1944.field_9282, blockPos);
    }

    public boolean canSeeSky() {
        class_2338 blockPos = this.updatedPos();
        class_1920 l = this.getLevelInternal();
        if (blockPos == null || l == null) {
            return true;
        }
        return this.getLevelInternal().method_8311(blockPos);
    }

    public boolean hasEntitiesWithin() {
        class_1920 level = this.getLevelInternal();
        class_2338 pos = this.updatedPos();
        if (pos == null) {
            return false;
        }
        if (level instanceof class_1937) {
            class_1937 l = (class_1937)level;
            return !l.method_8335(null, this.getStateInternal().method_26218((class_1922)level, pos).method_1107().method_996(pos)).isEmpty();
        }
        return false;
    }

    public boolean hasBlockTag(String tag) {
        class_6862 tagKey = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)class_2960.method_60654((String)tag));
        return this.getStateInternal().method_26164(tagKey);
    }

    public boolean hasAirAt() {
        return this.getStateInternal().method_26215();
    }

    public boolean hasFluid() {
        return !this.getStateInternal().method_26227().method_15769();
    }

    public String fluid() {
        return class_7923.field_41173.method_10221((Object)this.getStateInternal().method_26227().method_15772()).toString();
    }

    public boolean hasBlockEntity() {
        return this.getStateInternal().method_31709();
    }

    public String blockEntity() {
        class_2586 be = this.getBlockEntityInternal();
        if (be != null) {
            return be.method_11017().method_53254().method_55840();
        }
        return "null";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object environmentAttribute(String attributeName) {
        if (this.inEnvironmentAttributeCall) {
            return null;
        }
        try {
            class_638 lr;
            this.inEnvironmentAttributeCall = true;
            class_2338 pos = this.getPosInternal();
            if (pos == null) {
                pos = class_2338.field_10980;
            }
            class_12197<?> attr = ExpUtils.parseEnvAttr(attributeName);
            class_1920 class_19202 = this.getLevelInternal();
            if (class_19202 instanceof class_4538) {
                class_4538 lrr = (class_4538)class_19202;
                lr = lrr;
            } else {
                lr = class_310.method_1551().field_1687;
                if (lr == null) {
                    throw new IllegalStateException("No level available for environment attribute retrieval!");
                }
            }
            Object object = lr.method_75598().method_75697((class_12197)Preconditions.checkNotNull(attr), pos);
            return object;
        }
        finally {
            this.inEnvironmentAttributeCall = false;
        }
    }

    public String getBlock() {
        return this.block();
    }

    public String getBlockState() {
        return this.blockState();
    }

    public Object getBlockStateValue(Object object) {
        return this.blockStateValue(object);
    }

    public String getBiome() {
        return this.biome();
    }

    public double getBiomeIndex() {
        return this.biomeIndex();
    }

    public double getBiomeIndex(String string) {
        return this.biomeIndex(string);
    }

    public double getTemperature() {
        return this.temperature();
    }

    public double getDownfall() {
        return this.downfall();
    }

    public double getSkyLight() {
        return this.skyLight();
    }

    public double getBlockLight() {
        return this.blockLight();
    }

    public String getFluid() {
        return this.fluid();
    }

    public String getBlockEntity() {
        return this.blockEntity();
    }

    public Object getEnvironmentAttribute(String string) {
        return this.environmentAttribute(string);
    }
}

