/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.common.reloader;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.mehvahdjukaar.polytone.common.struc.ArrayImage;
import net.mehvahdjukaar.polytone.common.struc.ListUtils;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3518;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7654;
import org.apache.commons.lang3.StringUtils;

public abstract class PartialReloader<T> {
    public static final Gson GSON = new Gson();
    protected String[] names;

    protected PartialReloader(String ... name) {
        this.names = name;
    }

    public String toString() {
        return StringUtils.capitalize((String)(this.names[0].replace("_", " ") + " Reloader"));
    }

    protected Map<class_2960, JsonElement> getJsonsInDirectories(class_3300 resourceManager) {
        Map<class_2960, JsonElement> jsons = ListUtils.sortedMap();
        for (String name : this.names) {
            HashMap<class_2960, JsonElement> js = new HashMap<class_2960, JsonElement>();
            PartialReloader.scanDirectory(resourceManager, "polytone/" + name, GSON, js);
            PartialReloader.greedyAddAll(js, jsons);
        }
        return jsons;
    }

    public static void scanDirectory(class_3300 resourceManager, String string, Gson gson, Map<class_2960, JsonElement> map) {
        class_7654 fileToIdConverter = class_7654.method_45114((String)string);
        for (Map.Entry entry : fileToIdConverter.method_45113(resourceManager).entrySet()) {
            class_2960 resourceLocation = (class_2960)entry.getKey();
            class_2960 resourceLocation2 = fileToIdConverter.method_45115(resourceLocation);
            try (BufferedReader reader = ((class_3298)entry.getValue()).method_43039();){
                JsonElement jsonElement = (JsonElement)class_3518.method_15276((Gson)gson, (Reader)reader, JsonElement.class);
                JsonElement jsonElement2 = map.put(resourceLocation2, jsonElement);
                if (jsonElement2 == null) continue;
                throw new IllegalStateException("Duplicate data file ignored with ID " + String.valueOf(resourceLocation2));
            }
            catch (JsonParseException | IOException | IllegalArgumentException var14) {
                throw new IllegalStateException("Couldn't parse data file " + String.valueOf(resourceLocation2) + " from " + String.valueOf(resourceLocation), var14);
            }
        }
    }

    private static <T> void greedyAddAll(Map<class_2960, T> js, Map<class_2960, T> jsons) {
        for (Map.Entry<class_2960, T> entry : js.entrySet()) {
            class_2960 r = entry.getKey();
            T j = entry.getValue();
            jsons.put(r, j);
        }
    }

    protected Map<class_2960, ArrayImage> getImagesInDirectories(class_3300 resourceManager) {
        HashMap<class_2960, ArrayImage> images = new HashMap<class_2960, ArrayImage>();
        for (String name : this.names) {
            HashMap<class_2960, ArrayImage> im = new HashMap<class_2960, ArrayImage>();
            ArrayImage.scanDirectory(resourceManager, "polytone/" + name, im);
            PartialReloader.greedyAddAll(im, images);
        }
        return images;
    }

    protected Map<class_2960, ArrayImage.Group> getGroupedImagesInDirectories(class_3300 manager) {
        return ArrayImage.groupTextures(this.getImagesInDirectories(manager));
    }

    protected void earlyProcess(class_3302.class_11558 sharedState) {
    }

    protected abstract T prepare(class_3302.class_11558 var1);

    protected abstract void parseWithLevel(T var1, class_6903<JsonElement> var2, class_7225.class_7874 var3);

    protected abstract void applyWithLevel(class_7225.class_7874 var1, boolean var2);

    protected abstract void resetWithLevel(boolean var1);
}

