/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.common.reloader;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.common.reloader.PartialReloader;
import net.mehvahdjukaar.polytone.common.struc.PropertiesUtils;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3518;

public abstract class SingleJsonOrPropertiesReloadListener
extends PartialReloader<Map<class_2960, JsonElement>> {
    private static final Gson GSON = new Gson();
    private final String[] folders;
    private final String propertiesName;
    private final String jsonName;

    protected SingleJsonOrPropertiesReloadListener(String myName, String propertiesName, String jsonName, String ... possibleFolderLocations) {
        super(myName);
        this.folders = possibleFolderLocations;
        this.propertiesName = propertiesName;
        this.jsonName = jsonName;
    }

    @Override
    protected Map<class_2960, JsonElement> prepare(class_3302.class_11558 sharedState) {
        class_3300 resourceManager = sharedState.method_72361();
        HashMap<class_2960, Object> jsonObjects = new HashMap<class_2960, Object>();
        for (String path : this.folders) {
            Map propertiesResources = resourceManager.method_41265(path, id -> id.method_12832().endsWith(this.propertiesName));
            for (Map.Entry entry : propertiesResources.entrySet()) {
                List resourceStack = (List)entry.getValue();
                for (class_3298 resource : resourceStack) {
                    try {
                        BufferedReader reader = resource.method_43039();
                        try {
                            Properties properties = new Properties();
                            properties.load(reader);
                            JsonObject json = PropertiesUtils.propertiesToJson(properties);
                            jsonObjects.put((class_2960)entry.getKey(), json);
                        }
                        finally {
                            if (reader == null) continue;
                            ((Reader)reader).close();
                        }
                    }
                    catch (IOException | IllegalArgumentException ex) {
                        Polytone.LOGGER.error("Couldn't parse .properties file {}:", (Object)resource, (Object)ex);
                    }
                }
            }
            Map resources = resourceManager.method_41265(path, id -> id.method_12832().endsWith(this.jsonName));
            for (Map.Entry entrySet : resources.entrySet()) {
                List resourceStack = (List)entrySet.getValue();
                class_2960 id2 = (class_2960)entrySet.getKey();
                for (class_3298 resource : resourceStack) {
                    try {
                        BufferedReader reader = resource.method_43039();
                        try {
                            JsonElement jsonElement = (JsonElement)class_3518.method_15276((Gson)GSON, (Reader)reader, JsonElement.class);
                            if (jsonObjects.containsKey(id2)) {
                                Polytone.LOGGER.warn("Found duplicate color.json with path {}. Old one will be overwritten. Be sure to put this file in your own namespace, not minecraft one!", (Object)id2);
                            }
                            jsonObjects.put(id2, jsonElement);
                        }
                        finally {
                            if (reader == null) continue;
                            ((Reader)reader).close();
                        }
                    }
                    catch (JsonParseException | IOException | IllegalArgumentException ex) {
                        Polytone.LOGGER.error("Couldn't parse data file {}:", (Object)resource, (Object)ex);
                    }
                }
            }
        }
        return ImmutableMap.copyOf(jsonObjects);
    }
}

