/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.common.struc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import net.minecraft.class_2960;

public class ListUtils {
    public static <T> Set<T> mergeSet(Set<T> first, Set<T> second) {
        HashSet<T> set = new HashSet<T>();
        set.addAll(first);
        set.addAll(second);
        return Collections.unmodifiableSet(set);
    }

    public static <T> Optional<List<T>> mergeList(Optional<List<T>> newObj, Optional<List<T>> oldObj) {
        if (newObj.isPresent() && oldObj.isPresent()) {
            return Optional.of(ListUtils.mergeList(newObj.get(), oldObj.get()));
        }
        if (newObj.isPresent()) {
            return newObj;
        }
        return oldObj;
    }

    public static <T> List<T> mergeList(List<? extends T> newObj, List<? extends T> oldObj) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.addAll(oldObj);
        list.addAll(newObj);
        return Collections.unmodifiableList(list);
    }

    public static <T, V> Map<T, V> mergedMap(Map<T, V> newObj, Map<T, V> oldObj) {
        HashMap<T, V> map = new HashMap<T, V>();
        map.putAll(oldObj);
        map.putAll(newObj);
        return Collections.unmodifiableMap(map);
    }

    public static <T> Map<class_2960, T> sortedMap() {
        return new TreeMap(Comparator.comparing(class_2960::toString).reversed());
    }
}

