/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.content.biome;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.mehvahdjukaar.polytone.PlatStuff;
import net.mehvahdjukaar.polytone.common.ColorUtils;
import net.mehvahdjukaar.polytone.common.Targets;
import net.mehvahdjukaar.polytone.common.attributes.EnvironmentAttributeMapMod;
import net.mehvahdjukaar.polytone.common.codec.CodecUtils;
import net.minecraft.class_12199;
import net.minecraft.class_1959;
import net.minecraft.class_4763;
import org.jspecify.annotations.NonNull;

public record BiomeEffectModifier(Optional<Integer> waterColor, Optional<Integer> foliageColorOverride, Optional<Integer> dryFoliageColorOverride, Optional<Integer> grassColorOverride, Optional<class_4763.class_5486> grassColorModifier, BiomeEnvAttributeModifications attributeModifications, Targets targets) {
    public static final Codec<BiomeEffectModifier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ColorUtils.COLOR.optionalFieldOf("water_color").forGetter(BiomeEffectModifier::waterColor), (App)ColorUtils.COLOR.optionalFieldOf("foliage_color").forGetter(BiomeEffectModifier::foliageColorOverride), (App)ColorUtils.COLOR.optionalFieldOf("dry_foliage_color").forGetter(BiomeEffectModifier::foliageColorOverride), (App)ColorUtils.COLOR.optionalFieldOf("grass_color").forGetter(BiomeEffectModifier::grassColorOverride), (App)class_4763.class_5486.field_26429.optionalFieldOf("grass_color_modifier").forGetter(BiomeEffectModifier::grassColorModifier), (App)BiomeEnvAttributeModifications.CODEC.optionalFieldOf("attributes_modifiers", (Object)BiomeEnvAttributeModifications.EMPTY).forGetter(BiomeEffectModifier::attributeModifications), (App)Targets.CODEC.optionalFieldOf("targets", (Object)Targets.EMPTY).forGetter(BiomeEffectModifier::targets)).apply((Applicative)instance, BiomeEffectModifier::new));

    private static BiomeEffectModifier wrapVanilla(class_4763 effects, class_12199 attributes) {
        return new BiomeEffectModifier(Optional.of(effects.comp_5169()), effects.comp_5170(), effects.comp_5171(), effects.comp_5172(), Optional.of(effects.comp_5173()), BiomeEnvAttributeModifications.baseOnly(EnvironmentAttributeMapMod.wrapVanilla(attributes)), Targets.EMPTY);
    }

    public BiomeEffectModifier merge(BiomeEffectModifier newMod) {
        return new BiomeEffectModifier(newMod.waterColor.or(this::waterColor), newMod.foliageColorOverride.or(this::foliageColorOverride), newMod.dryFoliageColorOverride.or(this::dryFoliageColorOverride), newMod.grassColorOverride.or(this::grassColorOverride), newMod.grassColorModifier.or(this::grassColorModifier), this.attributeModifications.merge(newMod.attributeModifications), this.targets.merge(newMod.targets));
    }

    private class_4763 modifySpecialEffects(class_1959 biome) {
        class_4763 specialEffects = biome.method_24377();
        class_4763.class_4764 builder = new class_4763.class_4764();
        boolean changed = false;
        int newWaterColor = specialEffects.comp_5169();
        if (this.waterColor.isPresent()) {
            newWaterColor = this.waterColor.get();
            changed = true;
        }
        builder.method_24395(newWaterColor);
        Optional<Integer> newFoliageColorOverride = specialEffects.comp_5170;
        if (this.foliageColorOverride.isPresent()) {
            newFoliageColorOverride = this.foliageColorOverride;
            changed = true;
        }
        newFoliageColorOverride.ifPresent(arg_0 -> ((class_4763.class_4764)builder).method_30821(arg_0));
        Optional<Integer> newDryFoliageColorOverride = specialEffects.comp_5170;
        if (this.dryFoliageColorOverride.isPresent()) {
            newDryFoliageColorOverride = this.dryFoliageColorOverride;
            changed = true;
        }
        newDryFoliageColorOverride.ifPresent(arg_0 -> ((class_4763.class_4764)builder).method_68149(arg_0));
        Optional<Integer> newGrassColorOverride = specialEffects.comp_5172;
        if (this.grassColorOverride.isPresent()) {
            newGrassColorOverride = this.grassColorOverride;
            changed = true;
        }
        newGrassColorOverride.ifPresent(arg_0 -> ((class_4763.class_4764)builder).method_30822(arg_0));
        class_4763.class_5486 newGrassColorModifier = specialEffects.comp_5173;
        if (this.grassColorModifier.isPresent()) {
            newGrassColorModifier = this.grassColorModifier.get();
            changed = true;
        }
        builder.method_30818(newGrassColorModifier);
        if (!changed) {
            return specialEffects;
        }
        class_4763 copy = this.copy(specialEffects);
        PlatStuff.applyBiomeSurgery(biome, builder.method_24391());
        return copy;
    }

    private class_4763 copy(class_4763 effects) {
        class_4763.class_4764 builder = new class_4763.class_4764();
        builder.method_24395(effects.comp_5169());
        builder.method_30818(effects.comp_5173());
        effects.comp_5170().ifPresent(arg_0 -> ((class_4763.class_4764)builder).method_30821(arg_0));
        effects.comp_5171().ifPresent(arg_0 -> ((class_4763.class_4764)builder).method_68149(arg_0));
        effects.comp_5172().ifPresent(arg_0 -> ((class_4763.class_4764)builder).method_30822(arg_0));
        return builder.method_24391();
    }

    public BiomeEffectModifier apply(class_1959 biome) {
        class_12199 oldAttribute = this.attributeModifications.applyAllModifications(biome);
        class_4763 oldEffects = this.modifySpecialEffects(biome);
        return BiomeEffectModifier.wrapVanilla(oldEffects, oldAttribute);
    }

    public class_12199 getPostProcessAttributes() {
        return this.attributeModifications.postProcess.toVanilla();
    }

    public record BiomeEnvAttributeModifications(EnvironmentAttributeMapMod baseMod, EnvironmentAttributeMapMod postProcess) {
        public static final Codec<BiomeEnvAttributeModifications> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EnvironmentAttributeMapMod.CODEC.optionalFieldOf("base", (Object)EnvironmentAttributeMapMod.EMPTY).forGetter(m -> m.baseMod), (App)EnvironmentAttributeMapMod.CODEC.optionalFieldOf("post_process", (Object)EnvironmentAttributeMapMod.EMPTY).forGetter(m -> m.postProcess)).apply((Applicative)instance, BiomeEnvAttributeModifications::new));
        public static final Codec<BiomeEnvAttributeModifications> CODEC = CodecUtils.betterAlternative(EnvironmentAttributeMapMod.CODEC.xmap(BiomeEnvAttributeModifications::baseOnly, m -> m.baseMod), DIRECT_CODEC, (f, s) -> !f.isEmpty());
        public static final BiomeEnvAttributeModifications EMPTY = BiomeEnvAttributeModifications.baseOnly(EnvironmentAttributeMapMod.EMPTY);

        private static @NonNull BiomeEnvAttributeModifications baseOnly(EnvironmentAttributeMapMod mod) {
            return new BiomeEnvAttributeModifications(mod, EnvironmentAttributeMapMod.EMPTY);
        }

        public BiomeEnvAttributeModifications merge(BiomeEnvAttributeModifications newMod) {
            return new BiomeEnvAttributeModifications(this.baseMod.merge(newMod.baseMod), this.postProcess.merge(newMod.postProcess));
        }

        public boolean isEmpty() {
            return this.baseMod.isEmpty() && this.postProcess.isEmpty();
        }

        public class_12199 applyAllModifications(class_1959 biome) {
            class_12199 oldBase = biome.method_75734();
            if (!this.baseMod.isEmpty()) {
                biome.field_63809 = this.baseMod.modify(oldBase);
            }
            return oldBase;
        }
    }
}

