/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.content.biome;

import com.google.gson.JsonElement;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.common.Parsed;
import net.mehvahdjukaar.polytone.common.attributes.IExtendedInterpolator;
import net.mehvahdjukaar.polytone.common.reloader.JsonPartialReloader;
import net.mehvahdjukaar.polytone.content.biome.BiomeEffectModifier;
import net.minecraft.class_12197;
import net.minecraft.class_12199;
import net.minecraft.class_12205;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4543;
import net.minecraft.class_5455;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7924;

public class BiomeEffectsManager
extends JsonPartialReloader {
    private final Map<class_1959, BiomeEffectModifier> vanillaEffects = new HashMap<class_1959, BiomeEffectModifier>();
    private final Map<class_1959, BiomeEffectModifier> effectsToApply = new HashMap<class_1959, BiomeEffectModifier>();
    private boolean hasModifiedAttributes = false;
    private boolean hasPostAttributes = false;

    public BiomeEffectsManager() {
        super("biome_modifiers", "biome_effects");
    }

    @Override
    public void parseWithLevel(Map<class_2960, JsonElement> jsons, class_6903<JsonElement> ops, class_7225.class_7874 access) {
        for (Map.Entry<class_2960, BiomeEffectModifier> v : Parsed.batchParseOnlyEnabled(jsons, BiomeEffectModifier.CODEC, ops, "biome modifier")) {
            this.addEffect(v.getKey(), v.getValue(), access);
        }
    }

    private void addEffect(class_2960 pathId, BiomeEffectModifier mod, class_7225.class_7874 access) {
        class_7225.class_7226 registry = access.method_46762(class_7924.field_41236);
        for (class_6880 biome : mod.targets().compute(pathId, registry)) {
            this.effectsToApply.merge((class_1959)biome.comp_349(), mod, BiomeEffectModifier::merge);
        }
    }

    @Override
    public void applyWithLevel(class_7225.class_7874 registryAccess, boolean isLogIn) {
        if (isLogIn) {
            this.vanillaEffects.clear();
        }
        for (Map.Entry<class_1959, BiomeEffectModifier> v : this.effectsToApply.entrySet()) {
            class_1959 biome = v.getKey();
            BiomeEffectModifier modifier = v.getValue();
            BiomeEffectModifier old = modifier.apply(biome);
            this.vanillaEffects.put(biome, old);
        }
        if (!this.vanillaEffects.isEmpty()) {
            Polytone.LOGGER.info("Applied {} Custom Biome Effects Properties", (Object)this.vanillaEffects.size());
        }
        this.hasModifiedAttributes = this.effectsToApply.values().stream().anyMatch(m -> !m.attributeModifications().isEmpty());
        this.hasPostAttributes = this.effectsToApply.values().stream().anyMatch(m -> !m.attributeModifications().postProcess().isEmpty());
    }

    @Override
    public void resetWithLevel(boolean isLogOff) {
        class_638 level = class_310.method_1551().field_1687;
        if (level != null) {
            for (Map.Entry<class_1959, BiomeEffectModifier> v : this.vanillaEffects.entrySet()) {
                class_1959 biome = v.getKey();
                BiomeEffectModifier biomeModifier = v.getValue();
                biomeModifier.apply(biome);
            }
        }
        this.vanillaEffects.clear();
        this.effectsToApply.clear();
        this.hasPostAttributes = false;
        this.hasModifiedAttributes = false;
    }

    public boolean hasModifiedAttributes() {
        return this.hasModifiedAttributes;
    }

    public boolean hasPostAttributes() {
        return this.hasPostAttributes;
    }

    public void addPostLayers(class_12205.class_12314 builder, class_1937 level) {
        class_5455 registryAccess = level.method_30349();
        class_4543 biomeManager = level.method_22385();
        this.addBiomeLayer(builder, (class_7225<class_1959>)registryAccess.method_30530(class_7924.field_41236), biomeManager);
    }

    private void addBiomeLayer(class_12205.class_12314 builder, class_7225<class_1959> holderLookup, class_4543 biomeManager) {
        Stream allAttributesInPost = this.effectsToApply.entrySet().stream().flatMap(e -> ((BiomeEffectModifier)e.getValue()).getPostProcessAttributes().method_75666().stream()).distinct();
        allAttributesInPost.forEach(environmentAttribute -> this.addBiomeLayerForAttribute(builder, (class_12197)environmentAttribute, biomeManager));
    }

    private <Value> void addBiomeLayerForAttribute(class_12205.class_12314 builder, class_12197<Value> environmentAttribute, class_4543 biomeManager) {
        builder.method_76413(environmentAttribute, (object, vec3, spatialAttributeInterpolator) -> {
            if (spatialAttributeInterpolator != null && environmentAttribute.method_75654()) {
                spatialAttributeInterpolator = ((IExtendedInterpolator)spatialAttributeInterpolator).polytone$getOrCreatePostInterpolator();
                return spatialAttributeInterpolator.method_75712(environmentAttribute, object);
            }
            class_6880 holder = biomeManager.method_24938(vec3.field_1352, vec3.field_1351, vec3.field_1350);
            BiomeEffectModifier biomeEffectModifier = this.effectsToApply.get(holder.comp_349());
            if (biomeEffectModifier == null) {
                return object;
            }
            class_12199 posMap = biomeEffectModifier.getPostProcessAttributes();
            return posMap.method_75663(environmentAttribute, object);
        });
    }

    public class_12199 getPostAttributes(class_1959 value) {
        BiomeEffectModifier modifier = this.effectsToApply.get(value);
        if (modifier != null) {
            return modifier.getPostProcessAttributes();
        }
        return class_12199.field_63724;
    }
}

