/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.content.biome;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import java.util.Map;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.common.reloader.JsonPartialReloader;
import net.mehvahdjukaar.polytone.common.struc.MapRegistry;
import net.mehvahdjukaar.polytone.content.biome.BiomeIdMapper;
import net.minecraft.class_2960;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import org.jspecify.annotations.Nullable;

public class BiomeIdMapperManager
extends JsonPartialReloader {
    private final MapRegistry<BiomeIdMapper> biomeIdMappers = new MapRegistry("Biome ID Mappers");

    public BiomeIdMapperManager() {
        super("biome_id_mappers");
    }

    @Override
    protected void resetWithLevel(boolean logOff) {
        this.biomeIdMappers.clear();
    }

    @Override
    protected void parseWithLevel(Map<class_2960, JsonElement> jsons, class_6903<JsonElement> ops, class_7225.class_7874 access) {
        for (Map.Entry<class_2960, JsonElement> j : jsons.entrySet()) {
            JsonElement json = j.getValue();
            class_2960 id = j.getKey();
            BiomeIdMapper mapper = (BiomeIdMapper)((Pair)BiomeIdMapper.CODEC.decode(ops, (Object)json).getOrThrow(errorMsg -> new IllegalStateException("Could not decode Biome ID mapper with json id " + String.valueOf(id) + "\n error: " + errorMsg))).getFirst();
            try {
                this.biomeIdMappers.register(id, mapper);
            }
            catch (Exception e) {
                Polytone.LOGGER.warn("Found duplicate biome in biome id mapper {}", (Object)id);
            }
        }
    }

    @Override
    protected void applyWithLevel(class_7225.class_7874 access, boolean isLogIn) {
    }

    public Codec<BiomeIdMapper> byNameCodec() {
        return this.biomeIdMappers;
    }

    public @Nullable BiomeIdMapper get(String biomeMapper) {
        return this.biomeIdMappers.getValue(biomeMapper);
    }
}

