/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.content.color;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.common.ColorUtils;
import net.mehvahdjukaar.polytone.common.exp.impl.EntityContextExpression;
import net.mehvahdjukaar.polytone.common.expressions.impl.IEntityExp;
import net.mehvahdjukaar.polytone.common.reloader.SingleJsonOrPropertiesReloadListener;
import net.mehvahdjukaar.polytone.common.struc.Vec3f;
import net.mehvahdjukaar.polytone.content.color.MapColorHelper;
import net.mehvahdjukaar.polytone.mixins.accessor.DustParticleOptionAccessor;
import net.minecraft.class_10022;
import net.minecraft.class_11462;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1767;
import net.minecraft.class_1844;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_2457;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2789;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3518;
import net.minecraft.class_3620;
import net.minecraft.class_4008;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_9381;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Nullable;

public class ColorManager
extends SingleJsonOrPropertiesReloadListener {
    private static final int DEFAULT_COLOR = class_9848.method_61318((float)1.0f, (float)1.0f, (float)0.0f, (float)0.0f);
    private final Object2IntMap<class_3620> vanillaMapColors = new Object2IntOpenHashMap();
    private final Map<class_1767, Integer> vanillaFireworkColors = new EnumMap<class_1767, Integer>(class_1767.class);
    private final Map<class_1767, Integer> vanillaDiffuseColors = new EnumMap<class_1767, Integer>(class_1767.class);
    private final Map<class_1767, Integer> vanillaTextColors = new EnumMap<class_1767, Integer>(class_1767.class);
    private final Map<class_124, Integer> vanillaChatFormatting = new EnumMap<class_124, Integer>(class_124.class);
    private final Object2IntMap<class_1291> vanillaEffectColors = new Object2IntOpenHashMap();
    private final Map<class_1291, Function<class_1293, class_2394>> vanillaEffectParticles = new HashMap<class_1291, Function<class_1293, class_2394>>();
    private final EnumMap<class_2789, Integer> vanillaBorderStatus = new EnumMap(class_2789.class);
    private final Map<class_1767, Integer> customSheepColors = new EnumMap<class_1767, Integer>(class_1767.class);
    private final Map<class_1767, Integer> originalSheepColors;
    protected final int[] originalRedstoneWireColors;
    protected final class_2583 originalSplash;
    @Nullable
    class_2960 xpOrbParticle;
    @Nullable
    private IEntityExp xpOrbColor;
    @Nullable
    private IEntityExp xpOrbColorR;
    @Nullable
    private IEntityExp xpOrbColorG;
    @Nullable
    private IEntityExp xpOrbColorB;
    private Integer xpBar;
    private Integer xpBarBack;
    private Integer enchantTableXp;
    private Integer skyFlashColor;
    @Nullable
    private Integer fishingLineColor;
    @Nullable
    private Vec3f fishingLineOffset;

    public ColorManager() {
        super("colo_manager", "color.properties", "colors.json", new String[]{"polytone", "colormatic", "vanadium", "optifine"});
        this.originalSheepColors = new EnumMap<class_1767, Integer>(class_11462.class_11463.field_60687.field_60690);
        this.originalRedstoneWireColors = Arrays.copyOf(class_2457.field_24466, class_2457.field_24466.length);
        this.originalSplash = class_4008.field_63918;
        this.xpBar = null;
        this.xpBarBack = null;
        this.enchantTableXp = null;
        this.skyFlashColor = null;
        this.fishingLineColor = null;
        this.fishingLineOffset = null;
    }

    public Integer getSkyFlash() {
        return this.skyFlashColor;
    }

    public Integer getXpBar() {
        return this.xpBar;
    }

    public Integer getXpBarBackground() {
        return this.xpBarBack;
    }

    @Override
    protected void parseWithLevel(Map<class_2960, JsonElement> jsons, class_6903<JsonElement> ops, class_7225.class_7874 access) {
        ArrayList<class_2960> keySet = new ArrayList<class_2960>(jsons.keySet());
        for (class_2960 k : Lists.reverse(keySet)) {
            JsonElement root = jsons.get(k);
            try {
                this.parseColorJson(root, k);
            }
            catch (Exception e1) {
                Polytone.LOGGER.error("Failed to parse color.json in file {}", (Object)k, (Object)e1);
            }
        }
        this.regenSheepColors();
    }

    private void parseColorJson(JsonElement root, class_2960 fileId) {
        JsonObject obj = root.getAsJsonObject();
        ColorManager.doWith(obj, "map", (k, v) -> {
            class_3620 color = MapColorHelper.byName(k);
            if (color != null) {
                int col = ColorManager.parseColor(v);
                if (!this.vanillaMapColors.containsKey((Object)color)) {
                    this.vanillaMapColors.put((Object)color, color.field_16011);
                }
                color.field_16011 = col;
            } else {
                Polytone.LOGGER.warn("Unknown MapColor with name {}", k);
            }
        });
        ColorManager.doWith(obj, "environment", (k, v) -> {
            if (k.equals("flash")) {
                this.skyFlashColor = ColorManager.parseColor(v);
            }
        });
        ColorManager.doWith(obj, "dye", (k, v) -> {
            class_1767 color = class_1767.method_7793((String)k, null);
            if (color == null) {
                Polytone.LOGGER.warn("Unknown DyeColor with name {}", k);
                return;
            }
            for (Map.Entry<String, JsonElement> entry : ColorManager.entries(v)) {
                String param = entry.getKey();
                int col = ColorManager.parseColor(entry.getValue());
                switch (param) {
                    case "diffuse": {
                        if (!this.vanillaDiffuseColors.containsKey(color)) {
                            this.vanillaDiffuseColors.put(color, color.method_7787());
                        }
                        color.field_7943 = class_9848.method_61334((int)col);
                        break;
                    }
                    case "firework": {
                        if (!this.vanillaFireworkColors.containsKey(color)) {
                            this.vanillaFireworkColors.put(color, color.field_7960);
                        }
                        color.field_7960 = col;
                        break;
                    }
                    case "text": {
                        if (!this.vanillaTextColors.containsKey(color)) {
                            this.vanillaTextColors.put(color, color.field_16537);
                        }
                        color.field_16537 = col;
                    }
                }
            }
        });
        ColorManager.doWith(obj, "particle", (k, v) -> {
            class_2960 id = class_2960.method_60654((String)k.replace("\\", ""));
            try {
                int hex = ColorManager.parseColor(v);
                Polytone.PARTICLE_MODIFIERS.addCustomParticleColor(id, String.valueOf(hex));
            }
            catch (Exception e) {
                Polytone.PARTICLE_MODIFIERS.addCustomParticleColor(id, v.getAsString());
            }
        });
        ColorManager.doWith(obj, "fishing_line", (k, v) -> {
            switch (k) {
                case "color": {
                    this.fishingLineColor = ColorManager.parseColor(v);
                    break;
                }
                case "offset": {
                    this.fishingLineOffset = (Vec3f)((Pair)Vec3f.CODEC.decode((DynamicOps)JsonOps.INSTANCE, v).getOrThrow()).getFirst();
                }
            }
        });
        ColorManager.doWith(obj, "world_border", (k, v) -> {
            class_2789 status = class_2789.valueOf((String)k.toLowerCase(Locale.ROOT));
            int col = ColorManager.parseColor(v);
            if (!this.vanillaBorderStatus.containsKey(status)) {
                this.vanillaBorderStatus.put(status, status.method_11999());
            }
            status.field_12755 = col;
        });
        ColorManager.doWithOrAlias(obj, List.of("effect", "potion"), (k, v) -> {
            class_2960 id = class_2960.method_60654((String)k.replace("\\", ""));
            class_2394 particle = (class_2394)ColorManager.get(v, "particle", class_2398.field_25125);
            String color = ColorManager.getString(v, "color");
            Integer col = color == null && v instanceof JsonPrimitive ? Integer.valueOf(ColorManager.parseColor(v)) : Integer.valueOf(ColorManager.parseColor(color));
            if (!id.method_12832().equals("empty")) {
                if (id.method_12832().equals("water")) {
                    class_1844.field_49277 = col;
                } else {
                    class_1291 effect = class_7923.field_41174.method_17966(id).orElse(null);
                    if (effect != null) {
                        if (!this.vanillaEffectColors.containsKey((Object)effect)) {
                            this.vanillaEffectColors.put((Object)effect, effect.method_5556());
                        }
                        effect.field_5886 = col;
                        effect.field_49790 = mobEffectInstance -> {
                            int alpha = mobEffectInstance.method_5591() ? class_1291.field_49789 : 255;
                            return class_9381.method_58256((class_2396)class_2398.field_11226, (int)class_9848.method_61330((int)alpha, (int)col));
                        };
                        if (particle != null) {
                            if (!this.vanillaEffectParticles.containsKey(effect)) {
                                this.vanillaEffectParticles.put(effect, effect.field_49790);
                            }
                            effect.field_49790 = mobEffectInstance -> particle;
                        }
                    } else {
                        Polytone.LOGGER.warn("Unknown Mob Effect with name {}", (Object)id);
                    }
                }
            }
        });
        ColorManager.doWith(obj, "sheep", (k, v) -> {
            class_1767 color = class_1767.method_7793((String)k, null);
            if (color != null) {
                int col = class_9848.method_61334((int)ColorManager.parseColor(v));
                this.customSheepColors.put(color, col);
            } else {
                Polytone.LOGGER.warn("Unknown Dye Color with name {}", k);
            }
        });
        ColorManager.doWith(obj, "xporb", (k, v) -> {
            switch (k) {
                case "particle_replacement": {
                    Polytone.PARTICLE_MODIFIERS.setXpOrbReplace((JsonElement)v);
                    break;
                }
                case "color": {
                    this.xpOrbColor = new EntityContextExpression(v.getAsString());
                    break;
                }
                case "red": {
                    this.xpOrbColorR = new EntityContextExpression(v.getAsString());
                    break;
                }
                case "green": {
                    this.xpOrbColorG = new EntityContextExpression(v.getAsString());
                    break;
                }
                case "blue": {
                    this.xpOrbColorB = new EntityContextExpression(v.getAsString());
                }
            }
        });
        ColorManager.doWith(obj, "redstone", (k, v) -> {
            int code = Integer.parseInt(k);
            if (code < class_2457.field_24466.length) {
                int col = ColorManager.parseColor(v);
                float[] rgb = ColorUtils.unpack(col);
                class_2457.field_24466[code] = class_9848.method_61318((float)1.0f, (float)rgb[0], (float)rgb[1], (float)rgb[2]);
                if (code == 15) {
                    int maxPower;
                    class_2390.field_28272 = maxPower = class_9848.method_61318((float)1.0f, (float)rgb[0], (float)rgb[1], (float)rgb[2]);
                    ((DustParticleOptionAccessor)class_2390.field_11188).setColor(maxPower);
                }
            } else {
                Polytone.LOGGER.warn("Redstone color index must be between 0 and 15");
            }
        });
        ColorManager.doWith(obj, "text", (k, v) -> {
            if (k.equals("splash")) {
                int splashCol = ColorManager.parseColor(v);
                this.refreshSplash(class_2583.field_24360.method_36139(splashCol));
            } else if (k.equals("xpbar")) {
                if (v instanceof JsonPrimitive) {
                    this.xpBar = ColorManager.parseColor(v);
                } else {
                    for (Map.Entry<String, JsonElement> e : ColorManager.entries(v)) {
                        switch (e.getKey()) {
                            case "foreground": {
                                this.xpBar = ColorManager.parseColor(e.getValue());
                                break;
                            }
                            case "background": {
                                this.xpBarBack = ColorManager.parseColor(e.getValue());
                            }
                        }
                    }
                }
            } else if (k.startsWith("code:")) {
                String s = k.substring(5);
                int code = Integer.parseInt(s);
                class_124 text = class_124.method_534((int)code);
                this.setTextColor(text, ColorManager.parseColor(v));
            } else if (k.equals("code")) {
                for (Map.Entry<String, JsonElement> entry : ColorManager.entries(v)) {
                    String s = entry.getKey();
                    int code = Integer.parseInt(s);
                    class_124 text = class_124.method_534((int)code);
                    this.setTextColor(text, ColorManager.parseColor(entry.getValue()));
                }
            } else {
                class_124 text = class_124.method_533((String)k);
                this.setTextColor(text, ColorManager.parseColor(v));
            }
        });
        ColorManager.doWith(obj, "palette", (k, v) -> {
            if (k.equals("block") && v.isJsonObject()) {
                for (Map.Entry<String, JsonElement> entry : ColorManager.getEntries(v.getAsJsonObject(), "block")) {
                    String path = entry.getKey().replace("~/colormap/", fileId.method_12836() + ":");
                    Polytone.BLOCK_MODIFIERS.addSimpleColormap(class_2960.method_60654((String)path), entry.getValue().getAsString());
                }
            }
        });
    }

    private void refreshSplash(class_2583 style) {
        class_4008.field_63918 = style;
        class_4008 manager = class_310.method_1551().method_18095();
        List splashes = manager.field_17906;
        ArrayList<class_5250> newSplashes = new ArrayList<class_5250>();
        for (class_2561 c : splashes) {
            newSplashes.add(c.method_27661().method_27696(style));
        }
        manager.field_17906 = newSplashes;
    }

    private void setTextColor(class_124 text, int col) {
        if (!this.vanillaChatFormatting.containsKey(text)) {
            this.vanillaChatFormatting.put(text, text.method_532());
        }
        text.field_1053 = col;
        class_5251 tc = class_5251.method_27718((class_124)text);
        tc.field_24364 = col;
    }

    private static void doWith(JsonObject obj, String key, BiConsumer<String, JsonElement> entryHandler) {
        try {
            if (obj.has(key)) {
                JsonObject sub = class_3518.method_15296((JsonObject)obj, (String)key);
                for (Map.Entry entry : sub.entrySet()) {
                    entryHandler.accept((String)entry.getKey(), (JsonElement)entry.getValue());
                }
            }
        }
        catch (JsonParseException e) {
            throw new JsonParseException("Failed to parse color JSON for key: " + key, (Throwable)e);
        }
    }

    private static void doWithOrAlias(JsonObject obj, Collection<String> names, BiConsumer<String, JsonElement> entryHandler) {
        for (String s : names) {
            ColorManager.doWith(obj, s, entryHandler);
        }
    }

    private static Set<Map.Entry<String, JsonElement>> getEntries(JsonObject element, String key) {
        JsonElement elements = element.get(key);
        if (elements != null && elements.isJsonObject()) {
            return elements.getAsJsonObject().entrySet();
        }
        return Collections.emptySet();
    }

    private static <T> T get(JsonElement element, String key, Codec<T> codec) {
        JsonObject jo;
        JsonElement joo;
        if (element instanceof JsonObject && (joo = (jo = (JsonObject)element).get(key)) != null) {
            return (T)((Pair)codec.decode((DynamicOps)JsonOps.INSTANCE, (Object)joo).getOrThrow()).getFirst();
        }
        return null;
    }

    private static String getString(JsonElement element, String key) {
        JsonObject jo;
        JsonElement joo;
        if (element instanceof JsonObject && (joo = (jo = (JsonObject)element).get(key)) != null && joo.isJsonPrimitive() && joo.getAsJsonPrimitive().isString()) {
            return joo.getAsString();
        }
        return null;
    }

    private static Set<Map.Entry<String, JsonElement>> entries(JsonElement element) {
        if (element.isJsonObject()) {
            return element.getAsJsonObject().entrySet();
        }
        return Collections.emptySet();
    }

    private static int parseColor(JsonElement obj) {
        return (Integer)((Pair)ColorUtils.COLOR.decode((DynamicOps)JsonOps.INSTANCE, (Object)obj).getOrThrow()).getFirst();
    }

    private static int parseColor(String str) {
        str = str.replace("#", "").replace("0x", "");
        return Integer.parseInt(str.trim(), 16);
    }

    @Override
    protected void applyWithLevel(class_7225.class_7874 access, boolean isLogIn) {
    }

    @Override
    protected void resetWithLevel(boolean logOff) {
        class_1291 effect;
        class_3620 color;
        class_1844.field_49277 = 3694022;
        this.xpBar = null;
        this.xpOrbParticle = null;
        this.xpOrbColor = null;
        this.xpOrbColorR = null;
        this.xpOrbColorG = null;
        this.xpOrbColorB = null;
        this.fishingLineOffset = null;
        this.fishingLineColor = null;
        for (Map.Entry entry : this.vanillaMapColors.entrySet()) {
            color = (class_3620)entry.getKey();
            color.field_16011 = (Integer)entry.getValue();
        }
        this.vanillaMapColors.clear();
        for (Map.Entry entry : this.vanillaDiffuseColors.entrySet()) {
            color = (class_1767)entry.getKey();
            color.field_7943 = (Integer)entry.getValue();
        }
        this.vanillaDiffuseColors.clear();
        for (Map.Entry entry : this.vanillaFireworkColors.entrySet()) {
            color = (class_1767)entry.getKey();
            color.field_7960 = (Integer)entry.getValue();
        }
        this.vanillaFireworkColors.clear();
        for (Map.Entry entry : this.vanillaTextColors.entrySet()) {
            color = (class_1767)entry.getKey();
            color.field_16537 = (Integer)entry.getValue();
        }
        this.vanillaTextColors.clear();
        for (Map.Entry entry : this.vanillaChatFormatting.entrySet()) {
            class_124 text = (class_124)entry.getKey();
            text.field_1053 = (Integer)entry.getValue();
            class_5251 tc = class_5251.method_27718((class_124)text);
            tc.field_24364 = (Integer)entry.getValue();
        }
        this.vanillaChatFormatting.clear();
        for (Object2IntMap.Entry entry : this.vanillaEffectColors.object2IntEntrySet()) {
            effect = (class_1291)entry.getKey();
            effect.field_5886 = entry.getIntValue();
        }
        this.vanillaEffectColors.clear();
        for (Map.Entry entry : this.vanillaEffectParticles.entrySet()) {
            effect = (class_1291)entry.getKey();
            effect.field_49790 = (Function)entry.getValue();
        }
        this.vanillaEffectParticles.clear();
        for (Map.Entry entry : this.vanillaBorderStatus.entrySet()) {
            class_2789 status = (class_2789)entry.getKey();
            status.field_12755 = (Integer)entry.getValue();
        }
        this.vanillaBorderStatus.clear();
        class_2457.field_24466 = Arrays.copyOf(this.originalRedstoneWireColors, this.originalRedstoneWireColors.length);
        class_2390.field_28272 = DEFAULT_COLOR;
        ((DustParticleOptionAccessor)class_2390.field_11188).setColor(class_2390.field_28272);
    }

    public void regenSheepColors() {
        EnumMap<class_1767, Integer> map = new EnumMap<class_1767, Integer>(this.originalSheepColors);
        map.putAll(this.customSheepColors);
        this.customSheepColors.clear();
        class_11462.class_11463.field_60687.field_60690 = map;
    }

    public float @Nullable [] getXpOrbColor(class_10022 orb, float partialTicks) {
        return null;
    }

    @Nullable
    public Vec3f getFishingLineOffset() {
        return this.fishingLineOffset;
    }

    @Nullable
    public Integer getFishingLineColor() {
        return this.fishingLineColor;
    }
}

