/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.content.colormap;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Function;
import net.mehvahdjukaar.polytone.PlatStuff;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.common.ColorUtils;
import net.mehvahdjukaar.polytone.common.codec.CodecUtils;
import net.mehvahdjukaar.polytone.common.expressions.impl.IColormapExp;
import net.mehvahdjukaar.polytone.common.struc.ArrayImage;
import net.mehvahdjukaar.polytone.content.biome.BiomeIdMapper;
import net.mehvahdjukaar.polytone.content.colormap.BiomeCompoundColorGetter;
import net.mehvahdjukaar.polytone.content.colormap.ColormapColorModulator;
import net.mehvahdjukaar.polytone.content.colormap.IColorGetter;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3980;
import net.minecraft.class_4538;
import net.minecraft.class_638;
import net.minecraft.class_6539;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Colormap
implements IColorGetter,
class_6539 {
    private final IColormapExp xGetter;
    private final IColormapExp yGetter;
    private final BiomeIdMapper biomeMapper;
    private final boolean triangular;
    private final boolean rounds;
    private final boolean hasBiomeBlend;
    private final boolean usesBiome;
    private final boolean usesPos;
    private final boolean usesState;
    public boolean inlined = true;
    class_2960 debugID = null;
    private Integer defaultColor;
    private ArrayImage image = null;
    @Nullable
    private class_2960 explicitTargetTexture;
    @Nullable
    private final ColormapColorModulator colorMult;
    private final ThreadLocal<class_2680> stateHack = new ThreadLocal();
    private final ThreadLocal<Integer> yHack = new ThreadLocal();
    private final ThreadLocal<class_1920> levelHack = new ThreadLocal();
    static final Codec<Colormap> DIRECT_CODEC = RecordCodecBuilder.create(i -> i.group((App)ColorUtils.COLOR.optionalFieldOf("default_color").forGetter(c -> Optional.ofNullable(c.defaultColor)), (App)IColormapExp.CODEC.fieldOf("x_axis").forGetter(c -> c.xGetter), (App)IColormapExp.CODEC.fieldOf("y_axis").forGetter(c -> c.yGetter), (App)Codec.BOOL.optionalFieldOf("triangular", (Object)false).forGetter(c -> c.triangular), (App)Codec.BOOL.optionalFieldOf("rounds", (Object)true).forGetter(c -> c.rounds), (App)Codec.BOOL.optionalFieldOf("biome_blend").forGetter(c -> Optional.of(c.hasBiomeBlend)), (App)BiomeIdMapper.CODEC.optionalFieldOf("biome_id_mapper").forGetter(c -> Optional.of(c.biomeMapper)), (App)class_2960.field_25139.optionalFieldOf("texture_path").forGetter(c -> Optional.ofNullable(c.explicitTargetTexture)), (App)ColormapColorModulator.CODEC.optionalFieldOf("color_modifier").forGetter(c -> Optional.ofNullable(c.colorMult))).apply((Applicative)i, Colormap::new));
    public static final Codec<IColorGetter> DIRECT_REFERENCE_OR_EXPRESSION = Codec.withAlternative(CodecUtils.referenceOrDirect(Polytone.COLORMAPS.byNameCodec(), DIRECT_CODEC), (Codec)SINGLE_COLOR_OR_EXPRESSION, Function.identity());
    public static final Codec<IColorGetter> REFERENCE_OR_EXPRESSION = Codec.withAlternative(Polytone.COLORMAPS.byNameCodec(), (Codec)SINGLE_COLOR_OR_EXPRESSION);
    public static final Codec<IColorGetter> CODEC = Codec.withAlternative(DIRECT_REFERENCE_OR_EXPRESSION, BiomeCompoundColorGetter.CODEC);

    private Colormap(Optional<Integer> defaultColor, IColormapExp xGetter, IColormapExp yGetter, boolean triangular, boolean rounds, Optional<Boolean> biomeBlend, Optional<BiomeIdMapper> biomeMapper, Optional<class_2960> explicitTargetTexture, Optional<ColormapColorModulator> colorMult) {
        this.defaultColor = defaultColor.orElse(null);
        this.xGetter = xGetter;
        this.yGetter = yGetter;
        this.triangular = triangular;
        this.rounds = rounds;
        this.colorMult = colorMult.orElse(null);
        this.usesBiome = xGetter.usesBiome() || yGetter.usesBiome();
        this.usesPos = this.usesBiome || xGetter.usesPos() || yGetter.usesPos();
        this.usesState = xGetter.usesState() || yGetter.usesState();
        this.hasBiomeBlend = biomeBlend.orElse(this.usesBiome);
        this.biomeMapper = biomeMapper.orElse(BiomeIdMapper.LEGACY);
        this.explicitTargetTexture = explicitTargetTexture.orElse(null);
        if (this.hasBiomeBlend) {
            PlatStuff.registerColorResolver(this);
        }
    }

    private Colormap(IColormapExp xGetter, IColormapExp yGetter, boolean triangular) {
        this(Optional.empty(), xGetter, yGetter, triangular, true, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    @Override
    public Colormap makeConcurrent() {
        Colormap concurrentColormap = new Colormap(Optional.ofNullable(this.defaultColor), this.xGetter.createConcurrent(), this.yGetter.createConcurrent(), this.triangular, this.rounds, Optional.of(this.hasBiomeBlend), Optional.of(this.biomeMapper), Optional.ofNullable(this.explicitTargetTexture), Optional.ofNullable(this.colorMult == null ? null : this.colorMult.createConcurrent()));
        if (this.image != null) {
            concurrentColormap.acceptTexture(this.image);
        }
        return concurrentColormap;
    }

    public String toString() {
        return "Colormap{ID=" + String.valueOf(this.debugID) + ", triangular=" + this.triangular + ", rounds=" + this.rounds + ", hasBiomeBlend=" + this.hasBiomeBlend + ", inlined=" + this.inlined + "}";
    }

    public void acceptTexture(@NotNull ArrayImage image) {
        this.image = image;
        if (this.defaultColor == null) {
            this.defaultColor = this.sample(0.5f, 0.5f);
        }
    }

    @Override
    public boolean needsToFillTexture() {
        return this.image == null;
    }

    class_2960 getExplicitTargetTexture() {
        return this.explicitTargetTexture;
    }

    public class_2960 getTargetTexture(class_2960 def) {
        return this.explicitTargetTexture != null ? this.explicitTargetTexture : def;
    }

    public void setExplicitTargetTexture(class_2960 imageTarget) {
        this.explicitTargetTexture = imageTarget.method_45136(imageTarget.method_12832().replace(".png", ""));
    }

    public int getColor(@Nullable class_2680 state, @Nullable class_1920 level, @Nullable class_2338 pos, int i) {
        if (level == null) {
            return this.defaultColor;
        }
        if (pos == null && (this.usesPos || this.usesBiome)) {
            return this.defaultColor;
        }
        if (state == null && this.usesState) {
            return this.defaultColor;
        }
        if (this.hasBiomeBlend) {
            this.stateHack.set(state);
            this.yHack.set(pos != null ? pos.method_10264() : 0);
            this.levelHack.set(level);
            try {
                return level.method_23752(pos, (class_6539)this);
            }
            catch (Exception e) {
                Polytone.LOGGER.error("Error getting block tint at {} with colormap {}. Was it during a reload?", (Object)pos, (Object)this, (Object)e);
                return 0;
            }
        }
        class_1959 biome = null;
        if (this.usesBiome && level instanceof class_4538) {
            class_4538 l = (class_4538)level;
            biome = (class_1959)l.method_23753(pos).comp_349();
        }
        return this.sampleColor(level, state, pos, biome, null);
    }

    @Override
    public int sampleColor(@Nullable class_1920 level, @Nullable class_2680 state, @Nullable class_2338 pos, @Nullable class_1959 biome, @Nullable class_1799 item) {
        float temperature = class_3532.method_15363((float)this.xGetter.evaluate(level, state, pos, biome, this.biomeMapper, item), (float)0.0f, (float)1.0f);
        float humidity = class_3532.method_15363((float)this.yGetter.evaluate(level, state, pos, biome, this.biomeMapper, item), (float)0.0f, (float)1.0f);
        int sampled = this.sample(humidity, temperature);
        if (this.colorMult != null) {
            sampled = this.colorMult.evaluate(sampled, level, state, pos, biome, this.biomeMapper, item);
        }
        return sampled;
    }

    public int getColor(class_1959 biome, double x, double z) {
        Integer y = this.yHack.get();
        if (y == null) {
            y = 0;
        }
        return this.sampleColor(this.levelHack.get(), this.stateHack.get(), class_2338.method_49637((double)x, (double)y.intValue(), (double)z), biome, null);
    }

    public int calculateBlendedColor(class_1937 level, class_2338 pos) {
        int i = (Integer)class_310.method_1551().field_1690.method_41805().method_41753();
        class_2680 state = this.stateHack.get();
        if (i == 0) {
            return this.sampleColor((class_1920)level, state, pos, (class_1959)level.method_23753(pos).comp_349(), null);
        }
        int j = (i * 2 + 1) * (i * 2 + 1);
        int k = 0;
        int l = 0;
        int m = 0;
        class_3980 cursor3D = new class_3980(pos.method_10263() - i, pos.method_10264(), pos.method_10260() - i, pos.method_10263() + i, pos.method_10264(), pos.method_10260() + i);
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        while (cursor3D.method_17963()) {
            mutableBlockPos.method_10103(cursor3D.method_18671(), cursor3D.method_18672(), cursor3D.method_18673());
            int n = this.sampleColor((class_1920)level, state, (class_2338)mutableBlockPos, (class_1959)level.method_23753((class_2338)mutableBlockPos).comp_349(), null);
            k += (n & 0xFF0000) >> 16;
            l += (n & 0xFF00) >> 8;
            m += n & 0xFF;
        }
        return (k / j & 0xFF) << 16 | (l / j & 0xFF) << 8 | m / j & 0xFF;
    }

    private int sample(float textY, float textX) {
        if (this.triangular) {
            textY *= textX;
        }
        int width = this.image.width();
        int height = this.image.height();
        int wm = width - 1;
        int hm = height - 1;
        int scaledW = this.rounds ? Math.round(textX * (float)wm) : class_3532.method_15375((float)(textX * (float)wm));
        int scaledH = this.rounds ? Math.round(textY * (float)hm) : class_3532.method_15375((float)(textY * (float)hm));
        int w = Math.max(wm - scaledW, 0);
        int h = Math.max(hm - scaledH, 0);
        return this.image.pixels()[h][w];
    }

    @Override
    public int getItemColor(class_1799 itemStack, int i) {
        class_2338 pos = null;
        class_1959 biome = null;
        class_638 level = class_310.method_1551().field_1687;
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return this.defaultColor;
        }
        pos = player.method_24515();
        if (this.usesBiome) {
            if (level == null) {
                return this.defaultColor;
            }
            biome = (class_1959)level.method_23753(pos).comp_349();
        }
        return this.sampleColor((class_1920)player.method_73183(), null, pos, biome, itemStack);
    }

    public static Colormap simple(IColormapExp xGetter, IColormapExp yGetter) {
        return new Colormap(xGetter, yGetter, false);
    }

    public static Colormap createFixed() {
        return new Colormap(Optional.empty(), IColormapExp.ZERO, IColormapExp.ZERO, false, true, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    private static Colormap singleColor(int color) {
        Colormap c = new Colormap(IColormapExp.ZERO, IColormapExp.ZERO, false);
        c.acceptTexture(new ArrayImage(new int[][]{{color}}));
        return c;
    }

    public static Colormap createDefSquare() {
        return new Colormap(IColormapExp.TEMPERATURE, IColormapExp.DOWNFALL, false);
    }

    public static Colormap createDefTriangle() {
        return new Colormap(IColormapExp.TEMPERATURE, IColormapExp.DOWNFALL, true);
    }

    public static Colormap createTimeStrip() {
        return new Colormap(IColormapExp.DAY_TIME, IColormapExp.ZERO, false);
    }

    public static Colormap createBiomeId() {
        return new Colormap(Optional.empty(), IColormapExp.BIOME_ID, IColormapExp.Y_LEVEL, false, false, Optional.of(Boolean.TRUE), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public static Colormap createDamage() {
        return new Colormap(IColormapExp.DAMAGE, IColormapExp.ZERO, false);
    }
}

