/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.content.colormap;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.mehvahdjukaar.polytone.common.ColorUtils;
import net.mehvahdjukaar.polytone.common.expressions.impl.IColormapModExp;
import net.mehvahdjukaar.polytone.content.biome.BiomeIdMapper;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public class ColormapColorModulator {
    public static Codec<ColormapColorModulator> CODEC = RecordCodecBuilder.create(i -> i.group((App)IColormapModExp.CODEC.optionalFieldOf("red").forGetter(c -> c.red), (App)IColormapModExp.CODEC.optionalFieldOf("green").forGetter(c -> c.green), (App)IColormapModExp.CODEC.optionalFieldOf("blue").forGetter(c -> c.blue)).apply((Applicative)i, ColormapColorModulator::new));
    private final Optional<IColormapModExp> red;
    private final Optional<IColormapModExp> green;
    private final Optional<IColormapModExp> blue;

    protected ColormapColorModulator(Optional<IColormapModExp> red, Optional<IColormapModExp> green, Optional<IColormapModExp> blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public ColormapColorModulator createConcurrent() {
        return new ColormapColorModulator(this.red.map(IColormapModExp::createConcurrent), this.green.map(IColormapModExp::createConcurrent), this.blue.map(IColormapModExp::createConcurrent));
    }

    public int evaluate(int original, @Nullable class_1920 level, @Nullable class_2680 state, @Nullable class_2338 pos, @Nullable class_1959 biome, @Nullable BiomeIdMapper mapper, @Nullable class_1799 stack) {
        float[] values = ColorUtils.unpack(original);
        float red = values[0];
        float green = values[1];
        float blue = values[2];
        float newRed = this.red.map(exp -> Float.valueOf(exp.evaluate(red, green, blue, level, state, pos, biome, mapper, stack))).orElse(Float.valueOf(red)).floatValue();
        float newGreen = this.green.map(exp -> Float.valueOf(exp.evaluate(red, green, blue, level, state, pos, biome, mapper, stack))).orElse(Float.valueOf(green)).floatValue();
        float newBlue = this.blue.map(exp -> Float.valueOf(exp.evaluate(red, green, blue, level, state, pos, biome, mapper, stack))).orElse(Float.valueOf(blue)).floatValue();
        return ColorUtils.pack(newRed, newGreen, newBlue);
    }
}

