/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.content.colormap;

import com.mojang.serialization.Codec;
import net.mehvahdjukaar.polytone.common.ColorUtils;
import net.mehvahdjukaar.polytone.common.expressions.impl.IBlockExp;
import net.mehvahdjukaar.polytone.content.item.BarColor;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_322;
import net.minecraft.class_4538;
import net.minecraft.class_638;
import net.minecraft.class_6539;
import org.jetbrains.annotations.Nullable;

public interface IColorGetter
extends class_322,
BarColor {
    public static final Codec<IColorGetter> SINGLE_COLOR_CODEC = ColorUtils.COLOR.xmap(StaticColor::new, g -> {
        int color;
        Integer n;
        if (!(g instanceof StaticColor)) {
            n = 0;
            return n;
        }
        StaticColor $b$0 = (StaticColor)g;
        try {
            int patt1$temp;
            color = patt1$temp = $b$0.color();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        n = color;
        return n;
    });
    public static final Codec<IColorGetter> EXPRESSION_CODEC = IBlockExp.CODEC.xmap(ExpressionColor::new, g -> {
        IBlockExp iBlockExp;
        if (!(g instanceof ExpressionColor)) {
            iBlockExp = IBlockExp.ZERO;
            return iBlockExp;
        }
        ExpressionColor $b$0 = (ExpressionColor)g;
        try {
            IBlockExp patt1$temp;
            IBlockExp exp;
            iBlockExp = exp = (patt1$temp = $b$0.exp());
            return iBlockExp;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    });
    public static final Codec<IColorGetter> SINGLE_COLOR_OR_EXPRESSION = Codec.withAlternative(SINGLE_COLOR_CODEC, EXPRESSION_CODEC);

    default public boolean needsToFillTexture() {
        return false;
    }

    default public IColorGetter makeConcurrent() {
        return this;
    }

    public int sampleColor(@Nullable class_1920 var1, @Nullable class_2680 var2, @Nullable class_2338 var3, @Nullable class_1959 var4, @Nullable class_1799 var5);

    public record ExpressionColor(IBlockExp exp) implements IColorGetter
    {
        @Override
        public int sampleColor(@Nullable class_1920 level, @Nullable class_2680 state, @Nullable class_2338 pos, @Nullable class_1959 biome, @Nullable class_1799 item) {
            if (pos == null || state == null) {
                return 0;
            }
            return (int)this.exp.evaluate((class_4538)class_310.method_1551().field_1687, pos, state);
        }

        @Override
        public int getItemColor(class_1799 stack, int tintIndex) {
            return (int)this.exp.evaluate((class_4538)class_310.method_1551().field_1687, class_2338.field_10980, class_2246.field_10124.method_9564());
        }

        public int getColor(class_2680 blockState, @Nullable class_1920 blockAndTintGetter, @Nullable class_2338 blockPos, int i) {
            if (blockAndTintGetter instanceof class_4538) {
                class_4538 lr = (class_4538)blockAndTintGetter;
                if (blockPos != null) {
                    return (int)this.exp.evaluate(lr, blockPos, blockState);
                }
            }
            return 0;
        }
    }

    public record StaticColor(int color) implements IColorGetter
    {
        public int getColor(class_2680 state, class_1920 reader, class_2338 pos, int tintIndex) {
            return this.color;
        }

        @Override
        public int getItemColor(class_1799 itemStack, int i) {
            return this.color;
        }

        @Override
        public int sampleColor(@Nullable class_1920 level, @Nullable class_2680 state, @Nullable class_2338 pos, @Nullable class_1959 biome, @Nullable class_1799 item) {
            return this.color;
        }
    }

    public record OfItem(BarColor ic) implements IColorGetter
    {
        public int getColor(class_2680 state, class_1920 reader, class_2338 pos, int tintIndex) {
            return this.ic.getItemColor(class_1799.field_8037, tintIndex);
        }

        @Override
        public int getItemColor(class_1799 itemStack, int i) {
            return this.ic.getItemColor(itemStack, i);
        }

        @Override
        public int sampleColor(@Nullable class_1920 level, @Nullable class_2680 state, @Nullable class_2338 pos, @Nullable class_1959 biome, @Nullable class_1799 item) {
            return this.ic.getItemColor(item == null ? class_1799.field_8037 : item, 0);
        }
    }

    public record OfColorResolver(class_322 bc, class_6539 cr) implements IColorGetter,
    class_6539
    {
        public int getColor(class_2680 state, @Nullable class_1920 reader, @Nullable class_2338 pos, int tintIndex) {
            return this.bc.getColor(state, reader, pos, tintIndex);
        }

        @Override
        public int getItemColor(class_1799 stack, int tintIndex) {
            class_310 mc = class_310.method_1551();
            class_638 world = mc.field_1687;
            if (world == null) {
                return -1;
            }
            class_2338 pos = mc.field_1724.method_24515();
            class_2680 state = world.method_8320(pos);
            return this.bc.getColor(state, (class_1920)world, pos, tintIndex) | 0xFF000000;
        }

        public int getColor(class_1959 biome, double x, double z) {
            return this.cr.getColor(biome, x, z);
        }

        @Override
        public int sampleColor(@Nullable class_1920 level, @Nullable class_2680 state, @Nullable class_2338 pos, @Nullable class_1959 biome, @Nullable class_1799 item) {
            if (biome != null) {
                int x = pos == null ? 0 : pos.method_10263();
                int z = pos == null ? 0 : pos.method_10260();
                return this.cr.getColor(biome, (double)x, (double)z);
            }
            return -1;
        }
    }

    public record OfBlock(class_322 bc) implements IColorGetter
    {
        public int getColor(class_2680 state, class_1920 reader, class_2338 pos, int tintIndex) {
            return this.bc.getColor(state, reader, pos, tintIndex);
        }

        @Override
        public int getItemColor(class_1799 itemStack, int i) {
            class_310 mc = class_310.method_1551();
            class_638 world = mc.field_1687;
            if (world == null) {
                return -1;
            }
            class_2338 pos = mc.field_1724.method_24515();
            class_2680 state = world.method_8320(pos);
            return this.bc.getColor(state, (class_1920)world, pos, i) | 0xFF000000;
        }

        @Override
        public int sampleColor(@Nullable class_1920 level, @Nullable class_2680 state, @Nullable class_2338 pos, @Nullable class_1959 biome, @Nullable class_1799 item) {
            if (state != null && pos != null) {
                return this.bc.getColor(state, null, pos, 0) | 0xFF000000;
            }
            return -1;
        }
    }
}

