/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.content.dimension;

import com.google.gson.JsonElement;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.common.Parsed;
import net.mehvahdjukaar.polytone.common.attributes.EnvironmentAttributesHandler;
import net.mehvahdjukaar.polytone.common.reloader.JsonImgPartialReloader;
import net.mehvahdjukaar.polytone.content.dimension.DimensionEffectsModifier;
import net.minecraft.class_12199;
import net.minecraft.class_12205;
import net.minecraft.class_1937;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7924;

public class DimensionEffectsManager
extends JsonImgPartialReloader {
    private final Map<class_2960, DimensionEffectsModifier> effectsToApply = new HashMap<class_2960, DimensionEffectsModifier>();
    private final Map<class_5321<class_2874>, DimensionEffectsModifier> alteredVanillaEffects = new HashMap<class_5321<class_2874>, DimensionEffectsModifier>();
    private final Map<class_2960, Parsed<DimensionEffectsModifier>> extraMods = new HashMap<class_2960, Parsed<DimensionEffectsModifier>>();
    private final Map<class_5321<class_2874>, class_12199> postProcessEffects = new HashMap<class_5321<class_2874>, class_12199>();

    public DimensionEffectsManager() {
        super("dimension_modifiers", "dimension_effects");
    }

    @Override
    protected void resetWithLevel(boolean logOff) {
        this.effectsToApply.clear();
        this.extraMods.clear();
        this.postProcessEffects.clear();
    }

    @Override
    protected void parseWithLevel(JsonImgPartialReloader.Resources resources, class_6903<JsonElement> ops, class_7225.class_7874 access) {
        Map<class_2960, JsonElement> jsons = resources.jsons();
        Parsed.SortedMap<DimensionEffectsModifier> parsedModifiers = Parsed.batchParseAlways(jsons, DimensionEffectsModifier.CODEC, ops, "dimension modifier");
        parsedModifiers.putAll(this.extraMods);
        for (Map.Entry<class_2960, Parsed<DimensionEffectsModifier>> entry : parsedModifiers) {
            class_2960 id = entry.getKey();
            Parsed<DimensionEffectsModifier> parsed = entry.getValue();
            DimensionEffectsModifier modifier = parsed.getResultOrPartial();
            if (!parsed.isEnabled()) continue;
            this.addModifier(id, modifier, access);
        }
    }

    private void addModifier(class_2960 fileId, DimensionEffectsModifier mod, class_7225.class_7874 registryAccess) {
        for (class_6880<class_2874> h : mod.targets().compute(fileId, registryAccess)) {
            this.effectsToApply.merge(((class_5321)h.method_40230().get()).method_29177(), mod, DimensionEffectsModifier::merge);
        }
    }

    @Override
    protected void applyWithLevel(class_7225.class_7874 access, boolean isLogIn) {
        Iterator<Map.Entry<class_5321<class_2874>, DimensionEffectsModifier>> entries = this.alteredVanillaEffects.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry<class_5321<class_2874>, DimensionEffectsModifier> v = entries.next();
            class_5321<class_2874> dimensionKey = v.getKey();
            Optional dimType = access.method_46762(class_7924.field_41241).method_46746(dimensionKey);
            if (!dimType.isPresent()) continue;
            DimensionEffectsModifier mod = v.getValue();
            mod.apply((class_2874)((class_6880.class_6883)dimType.get()).comp_349());
            entries.remove();
        }
        class_638 level = class_310.method_1551().field_1687;
        if (level != null) {
            this.onDimensionChanged((class_6880<class_2874>)level.method_40134(), access);
        }
    }

    public void onDimensionChanged(class_6880<class_2874> currentDimHolder, class_7225.class_7874 access) {
        class_2874 currentDim = (class_2874)currentDimHolder.comp_349();
        class_5321 key = (class_5321)currentDimHolder.method_40230().get();
        for (Map.Entry<class_2960, DimensionEffectsModifier> v : this.effectsToApply.entrySet()) {
            class_2960 modId = v.getKey();
            DimensionEffectsModifier modifier = v.getValue();
            Collection<class_6880<class_2874>> targets = modifier.targets().compute(modId, access);
            if (!targets.contains(currentDimHolder)) continue;
            this.postProcessEffects.put((class_5321<class_2874>)key, modifier.getPostProcessAttributes());
            DimensionEffectsModifier old = modifier.apply(currentDim);
            this.alteredVanillaEffects.put((class_5321<class_2874>)key, old);
            Polytone.LOGGER.info("Applied Custom Dimension Effects Modifier '{}' to dimension '{}'", (Object)modId, (Object)currentDimHolder.method_55840());
        }
        EnvironmentAttributesHandler.refresh();
    }

    public void addConvertedBlockProperties(Map<class_2960, Parsed<DimensionEffectsModifier>> converted) {
        this.extraMods.clear();
        this.extraMods.putAll(converted);
    }

    public void addPostLayers(class_12205.class_12314 builder, class_1937 level) {
        class_12199 post = this.postProcessEffects.get(level.method_40134().method_40230().get());
        if (post != null) {
            builder.method_76417(post);
        }
    }

    public boolean hasModifiedAttributes() {
        return this.effectsToApply.values().stream().anyMatch(m -> !m.attributeModifications().isEmpty());
    }
}

