/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.content.dimension;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.common.attributes.EnvironmentAttributeMapMod;
import net.mehvahdjukaar.polytone.common.codec.CodecUtils;
import net.mehvahdjukaar.polytone.content.dimension.DimensionTarget;
import net.mehvahdjukaar.polytone.content.lightmap.Lightmap;
import net.mehvahdjukaar.polytone.mixins.accessor.DimensionTypeAccessor;
import net.minecraft.class_12199;
import net.minecraft.class_12316;
import net.minecraft.class_2874;

public record DimensionEffectsModifier(DimensionEnvAttributeModifications attributeModifications, Optional<class_2874.class_12326> skybox, Optional<class_2874.class_12325> cardinalLightType, Optional<Float> ambientLight, Optional<Boolean> hasSkylight, Optional<Lightmap> lightmap, DimensionTarget targets) {
    public static final Decoder<DimensionEffectsModifier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)DimensionEnvAttributeModifications.CODEC.optionalFieldOf("attributes_modifiers", (Object)DimensionEnvAttributeModifications.EMPTY).forGetter(DimensionEffectsModifier::attributeModifications), (App)class_2874.class_12326.field_64388.optionalFieldOf("skybox").forGetter(DimensionEffectsModifier::skybox), (App)class_2874.class_12325.field_64382.optionalFieldOf("cardinal_light").forGetter(DimensionEffectsModifier::cardinalLightType), (App)Codec.FLOAT.optionalFieldOf("ambient_light").forGetter(DimensionEffectsModifier::ambientLight), (App)Codec.BOOL.optionalFieldOf("has_skylight").forGetter(DimensionEffectsModifier::hasSkylight), (App)Polytone.LIGHTMAPS.byNameCodec().optionalFieldOf("lightmap").forGetter(DimensionEffectsModifier::lightmap), (App)DimensionTarget.CODEC.optionalFieldOf("targets", (Object)DimensionTarget.EMPTY).forGetter(DimensionEffectsModifier::targets)).apply((Applicative)instance, DimensionEffectsModifier::new));

    public DimensionEffectsModifier merge(DimensionEffectsModifier newMod) {
        return new DimensionEffectsModifier(this.attributeModifications.merge(newMod.attributeModifications), newMod.skybox.or(this::skybox), newMod.cardinalLightType.or(this::cardinalLightType), newMod.ambientLight.or(this::ambientLight), newMod.hasSkylight.or(this::hasSkylight), newMod.lightmap.or(this::lightmap), newMod.targets);
    }

    public DimensionEffectsModifier apply(class_2874 dimension) {
        DimensionTypeAccessor accessor = (DimensionTypeAccessor)dimension;
        Optional<Boolean> oldHasSkylight = Optional.empty();
        if (this.hasSkylight.isPresent()) {
            oldHasSkylight = Optional.of(dimension.comp_642());
            accessor.setHasSkyLight(this.hasSkylight.get());
        }
        Optional<Float> oldAmbient = Optional.empty();
        if (this.ambientLight.isPresent()) {
            oldAmbient = Optional.of(Float.valueOf(dimension.comp_656()));
            accessor.setAmbientLight(this.ambientLight.get().floatValue());
        }
        Optional<class_2874.class_12326> oldSky = Optional.empty();
        if (this.skybox.isPresent()) {
            oldSky = Optional.of(dimension.comp_5220());
            accessor.setSkybox(this.skybox.get());
        }
        Optional<class_2874.class_12325> oldCloud = Optional.empty();
        if (this.cardinalLightType.isPresent()) {
            oldCloud = Optional.of(dimension.comp_5221());
            accessor.setCardinalLightType(this.cardinalLightType.get());
        }
        DimensionEnvAttributeModifications oldMods = this.attributeModifications.applyAllModifications(dimension);
        return new DimensionEffectsModifier(oldMods, oldSky, oldCloud, oldAmbient, oldHasSkylight, Optional.empty(), DimensionTarget.EMPTY);
    }

    public class_12199 getPostProcessAttributes() {
        return this.attributeModifications.postProcess.toVanilla();
    }

    public record DimensionEnvAttributeModifications(EnvironmentAttributeMapMod baseMod, EnvironmentAttributeMapMod rainMod, EnvironmentAttributeMapMod thunderMod, EnvironmentAttributeMapMod postProcess) {
        public static final Codec<DimensionEnvAttributeModifications> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EnvironmentAttributeMapMod.CODEC.optionalFieldOf("base", (Object)EnvironmentAttributeMapMod.EMPTY).forGetter(m -> m.baseMod), (App)EnvironmentAttributeMapMod.CODEC.optionalFieldOf("rain", (Object)EnvironmentAttributeMapMod.EMPTY).forGetter(m -> m.rainMod), (App)EnvironmentAttributeMapMod.CODEC.optionalFieldOf("thunder", (Object)EnvironmentAttributeMapMod.EMPTY).forGetter(m -> m.thunderMod), (App)EnvironmentAttributeMapMod.CODEC.optionalFieldOf("post_process", (Object)EnvironmentAttributeMapMod.EMPTY).forGetter(m -> m.postProcess)).apply((Applicative)instance, DimensionEnvAttributeModifications::new));
        public static final Codec<DimensionEnvAttributeModifications> CODEC = CodecUtils.betterAlternative(EnvironmentAttributeMapMod.CODEC.xmap(DimensionEnvAttributeModifications::baseOnly, m -> m.baseMod), DIRECT_CODEC, (f, s) -> !f.isEmpty());
        public static final DimensionEnvAttributeModifications EMPTY = DimensionEnvAttributeModifications.baseOnly(EnvironmentAttributeMapMod.EMPTY);

        private static DimensionEnvAttributeModifications baseOnly(EnvironmentAttributeMapMod mod) {
            return new DimensionEnvAttributeModifications(mod, EnvironmentAttributeMapMod.EMPTY, EnvironmentAttributeMapMod.EMPTY, EnvironmentAttributeMapMod.EMPTY);
        }

        public DimensionEnvAttributeModifications merge(DimensionEnvAttributeModifications newMod) {
            return new DimensionEnvAttributeModifications(this.baseMod.merge(newMod.baseMod), this.rainMod.merge(newMod.rainMod), this.thunderMod.merge(newMod.thunderMod), this.postProcess.merge(newMod.postProcess));
        }

        public boolean isEmpty() {
            return this.baseMod.isEmpty() && this.rainMod.isEmpty() && this.thunderMod.isEmpty() && this.postProcess.isEmpty();
        }

        public DimensionEnvAttributeModifications applyAllModifications(class_2874 dimension) {
            class_12199 oldBase = class_12199.field_63724;
            if (!this.baseMod.isEmpty()) {
                oldBase = dimension.comp_5146();
                ((DimensionTypeAccessor)dimension).setAttributes(this.baseMod.modify(oldBase));
            }
            class_12199 oldRain = class_12199.field_63724;
            if (!this.rainMod.isEmpty()) {
                oldRain = class_12316.field_64349;
                class_12316.field_64349 = this.rainMod.modify(oldRain);
            }
            class_12199 oldThunder = class_12199.field_63724;
            if (!this.thunderMod.isEmpty()) {
                oldThunder = class_12316.field_64350;
                class_12316.field_64350 = this.thunderMod.modify(oldThunder);
            }
            return new DimensionEnvAttributeModifications(EnvironmentAttributeMapMod.wrapVanilla(oldBase), EnvironmentAttributeMapMod.wrapVanilla(oldRain), EnvironmentAttributeMapMod.wrapVanilla(oldThunder), EnvironmentAttributeMapMod.EMPTY);
        }
    }
}

