/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.content.dimension;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.class_12199;
import net.minecraft.class_12206;
import net.minecraft.class_2874;

public record DimensionTemplate(Optional<Long> fixedTime, Optional<Boolean> hasSkyLight, Optional<Boolean> hasCeiling, Optional<Boolean> ultraWarm, Optional<Boolean> natural, Optional<Double> coordinateScale, Optional<Boolean> bedWorks, Optional<Boolean> respawnAnchorWorks, Optional<Integer> minY, Optional<Integer> height, Optional<Integer> logicalHeight, Optional<Float> ambientLight) {
    public static final Codec<DimensionTemplate> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.optionalFieldOf("fixed_time").forGetter(DimensionTemplate::fixedTime), (App)Codec.BOOL.optionalFieldOf("has_sky_light").forGetter(DimensionTemplate::hasSkyLight), (App)Codec.BOOL.optionalFieldOf("has_ceiling").forGetter(DimensionTemplate::hasCeiling), (App)Codec.BOOL.optionalFieldOf("ultra_warm").forGetter(DimensionTemplate::ultraWarm), (App)Codec.BOOL.optionalFieldOf("natural").forGetter(DimensionTemplate::natural), (App)Codec.DOUBLE.optionalFieldOf("coordinate_scale").forGetter(DimensionTemplate::coordinateScale), (App)Codec.BOOL.optionalFieldOf("bed_works").forGetter(DimensionTemplate::bedWorks), (App)Codec.BOOL.optionalFieldOf("respawn_anchor_works").forGetter(DimensionTemplate::respawnAnchorWorks), (App)Codec.INT.optionalFieldOf("min_y").forGetter(DimensionTemplate::minY), (App)Codec.INT.optionalFieldOf("height").forGetter(DimensionTemplate::height), (App)Codec.INT.optionalFieldOf("logical_height").forGetter(DimensionTemplate::logicalHeight), (App)Codec.FLOAT.optionalFieldOf("ambient_light").forGetter(DimensionTemplate::ambientLight)).apply((Applicative)instance, DimensionTemplate::new));

    public boolean matches(class_2874 dimensionType) {
        boolean dimensionIsRespawnAnchorWorks;
        boolean dimensionIsBedWorks;
        boolean dimensionIsUltraWarm;
        class_12199 dimAttributes = dimensionType.comp_5146();
        if (this.fixedTime.isPresent() && !dimensionType.comp_5219()) {
            return false;
        }
        if (this.hasSkyLight.isPresent() && !this.hasSkyLight.get().equals(dimensionType.comp_642())) {
            return false;
        }
        if (this.hasCeiling.isPresent() && !this.hasCeiling.get().equals(dimensionType.comp_643())) {
            return false;
        }
        boolean bl = dimensionIsUltraWarm = dimAttributes.method_75662(class_12206.field_63755) != null || dimAttributes.method_75662(class_12206.field_63759) != null;
        if (this.ultraWarm.isPresent() && !this.ultraWarm.get().equals(dimensionIsUltraWarm)) {
            return false;
        }
        if (this.coordinateScale.isPresent() && !this.coordinateScale.get().equals(dimensionType.comp_646())) {
            return false;
        }
        boolean bl2 = dimensionIsBedWorks = dimAttributes.method_75662(class_12206.field_63756) != null;
        if (this.bedWorks.isPresent() && !this.bedWorks.get().equals(dimensionIsBedWorks)) {
            return false;
        }
        boolean bl3 = dimensionIsRespawnAnchorWorks = dimAttributes.method_75662(class_12206.field_63757) != null;
        if (this.respawnAnchorWorks.isPresent() && !this.respawnAnchorWorks.get().equals(dimensionIsRespawnAnchorWorks)) {
            return false;
        }
        if (this.minY.isPresent() && !this.minY.get().equals(dimensionType.comp_651())) {
            return false;
        }
        if (this.height.isPresent() && !this.height.get().equals(dimensionType.comp_652())) {
            return false;
        }
        if (this.logicalHeight.isPresent() && !this.logicalHeight.get().equals(dimensionType.comp_653())) {
            return false;
        }
        return !this.ambientLight.isPresent() || this.ambientLight.get().equals(Float.valueOf(dimensionType.comp_656()));
    }
}

