/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.content.entity;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.mehvahdjukaar.polytone.common.Targets;
import net.mehvahdjukaar.polytone.common.struc.ListUtils;
import net.mehvahdjukaar.polytone.content.entity.EntityParticleEmitter;
import net.mehvahdjukaar.polytone.content.entity.ParticleSpawnRecord;
import net.minecraft.class_10042;
import net.minecraft.class_12075;
import net.minecraft.class_4587;
import net.minecraft.class_922;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public record EntityModifier(List<EntityParticleEmitter> emitters, Targets targets) {
    public static final Codec<EntityModifier> CODEC = RecordCodecBuilder.create(i -> i.group((App)EntityParticleEmitter.CODEC.listOf().fieldOf("emitters").forGetter(em -> em.emitters), (App)Targets.CODEC.optionalFieldOf("targets", (Object)Targets.EMPTY).forGetter(em -> em.targets)).apply((Applicative)i, EntityModifier::new));

    public <S extends class_10042> List<ParticleSpawnRecord> gatherParticleSpawns(class_922<?, S, ?> renderer, class_4587 poseStack, S renderState, class_12075 cameraState) {
        ArrayList<ParticleSpawnRecord> records = new ArrayList<ParticleSpawnRecord>();
        for (EntityParticleEmitter emitter : this.emitters) {
            class_4587 spawn = emitter.getSpawnPose(renderer);
            if (spawn == null) continue;
            Matrix4f cameraToEntityArm = new Matrix4f((Matrix4fc)poseStack.method_23760().method_23761());
            cameraToEntityArm.mul((Matrix4fc)spawn.method_23760().method_23761());
            Vector3f cameraWorldPos = cameraState.field_63078.method_46409();
            Matrix4f worldTransform = new Matrix4f().translation((Vector3fc)cameraWorldPos).mul((Matrix4fc)cameraToEntityArm);
            records.add(new ParticleSpawnRecord((Matrix4fc)worldTransform, emitter));
        }
        return records;
    }

    public EntityModifier merge(EntityModifier entityModifier) {
        return new EntityModifier(ListUtils.mergeList(this.emitters, entityModifier.emitters), this.targets.merge(entityModifier.targets));
    }
}

