/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.content.entity;

import com.google.gson.JsonElement;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.mehvahdjukaar.polytone.common.Parsed;
import net.mehvahdjukaar.polytone.common.reloader.JsonPartialReloader;
import net.mehvahdjukaar.polytone.content.entity.EntityModifier;
import net.mehvahdjukaar.polytone.content.entity.IRenderStateWithId;
import net.mehvahdjukaar.polytone.content.entity.ParticleSpawnRecord;
import net.minecraft.class_10042;
import net.minecraft.class_12075;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_922;

public class EntityModifiersManager
extends JsonPartialReloader {
    private final Map<class_1299<?>, EntityModifier> emittersPerEntity = new HashMap();
    private final Int2ObjectOpenHashMap<List<ParticleSpawnRecord>> spawnRecords = new Int2ObjectOpenHashMap();

    public EntityModifiersManager() {
        super("entity_modifiers");
    }

    @Override
    protected void parseWithLevel(Map<class_2960, JsonElement> jsons, class_6903<JsonElement> ops, class_7225.class_7874 access) {
        for (Map.Entry<class_2960, EntityModifier> j : Parsed.batchParseOnlyEnabled(jsons, EntityModifier.CODEC, ops, "Entity Modifiers")) {
            if (j == null) continue;
            this.addModifier(j.getKey(), j.getValue());
        }
    }

    private void addModifier(class_2960 fileId, EntityModifier mod) {
        for (class_6880 h : mod.targets().compute(fileId, class_7923.field_41177)) {
            this.emittersPerEntity.merge((class_1299)h.comp_349(), mod, EntityModifier::merge);
        }
    }

    @Override
    protected void applyWithLevel(class_7225.class_7874 access, boolean isLogIn) {
    }

    @Override
    protected void resetWithLevel(boolean logOff) {
        this.emittersPerEntity.clear();
    }

    public void onTick(class_1937 level) {
        for (Int2ObjectMap.Entry entry : this.spawnRecords.int2ObjectEntrySet()) {
            class_1297 entity = level.method_8469(entry.getIntKey());
            if (entity == null) continue;
            List value = (List)entry.getValue();
            for (ParticleSpawnRecord record : value) {
                record.emitter().tick(entity, record.transform());
            }
        }
        this.spawnRecords.clear();
    }

    public <S extends class_10042> void onEntityRender(class_922<?, S, ?> renderer, class_4587 poseStack, S renderState, class_12075 cameraState) {
        EntityModifier mod = this.emittersPerEntity.get(renderState.field_58171);
        if (mod != null) {
            int id = ((IRenderStateWithId)renderState).polytone$getId();
            if (this.spawnRecords.containsKey(id)) {
                return;
            }
            List<ParticleSpawnRecord> particleSpawns = mod.gatherParticleSpawns(renderer, poseStack, renderState, cameraState);
            if (!particleSpawns.isEmpty()) {
                this.spawnRecords.put(id, particleSpawns);
            }
        }
    }

    public void onEntityTick(class_1297 entity) {
    }
}

