/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.content.entity;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.common.codec.BiggerCodecs;
import net.mehvahdjukaar.polytone.common.codec.CodecUtils;
import net.mehvahdjukaar.polytone.common.expressions.impl.IEntityExp;
import net.mehvahdjukaar.polytone.content.particle.custom.ExtraDataParticleOptions;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2400;
import net.minecraft.class_4587;
import net.minecraft.class_5321;
import net.minecraft.class_630;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_922;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4fc;
import org.joml.Vector3f;

public record EntityParticleEmitter(List<String> bone, Optional<class_6880<class_2396<?>>> particleType, IEntityExp chance, IEntityExp count, IEntityExp x, IEntityExp y, IEntityExp z, IEntityExp dx, IEntityExp dy, IEntityExp dz, Optional<IEntityExp> r, Optional<IEntityExp> g, Optional<IEntityExp> b, Optional<IEntityExp> a, Optional<IEntityExp> roll, Optional<IEntityExp> size, Optional<IEntityExp> custom) {
    private static final Codec<List<String>> BONE_CODEC = Codec.STRING.xmap(s -> List.of(s.split("/.")), list -> String.join((CharSequence)".", list));
    public static final Codec<EntityParticleEmitter> CODEC = RecordCodecBuilder.create(i -> BiggerCodecs.group(i, BONE_CODEC.fieldOf("bone").forGetter(EntityParticleEmitter::bone), CodecUtils.forwardAwareHolderByNameCodec(class_7923.field_41180).fieldOf("particle").forGetter(EntityParticleEmitter::particleType), IEntityExp.CODEC.optionalFieldOf("chance", (Object)IEntityExp.ONE).forGetter(EntityParticleEmitter::chance), IEntityExp.CODEC.optionalFieldOf("count", (Object)IEntityExp.ONE).forGetter(EntityParticleEmitter::count), IEntityExp.CODEC.optionalFieldOf("x", (Object)IEntityExp.ZERO).forGetter(EntityParticleEmitter::x), IEntityExp.CODEC.optionalFieldOf("y", (Object)IEntityExp.ZERO).forGetter(EntityParticleEmitter::y), IEntityExp.CODEC.optionalFieldOf("z", (Object)IEntityExp.ZERO).forGetter(EntityParticleEmitter::z), IEntityExp.CODEC.optionalFieldOf("dx", (Object)IEntityExp.ZERO).forGetter(EntityParticleEmitter::dx), IEntityExp.CODEC.optionalFieldOf("dy", (Object)IEntityExp.ZERO).forGetter(EntityParticleEmitter::dy), IEntityExp.CODEC.optionalFieldOf("dz", (Object)IEntityExp.ZERO).forGetter(EntityParticleEmitter::dz), IEntityExp.CODEC.optionalFieldOf("r").forGetter(EntityParticleEmitter::r), IEntityExp.CODEC.optionalFieldOf("g").forGetter(EntityParticleEmitter::g), IEntityExp.CODEC.optionalFieldOf("b").forGetter(EntityParticleEmitter::b), IEntityExp.CODEC.optionalFieldOf("a").forGetter(EntityParticleEmitter::a), IEntityExp.CODEC.optionalFieldOf("roll").forGetter(EntityParticleEmitter::roll), IEntityExp.CODEC.optionalFieldOf("size").forGetter(EntityParticleEmitter::size), IEntityExp.CODEC.optionalFieldOf("custom").forGetter(EntityParticleEmitter::custom)).apply(i, EntityParticleEmitter::new));

    public void tick(class_1297 entity, Matrix4fc transform) {
        if (this.particleType.isEmpty()) {
            return;
        }
        double spawnChance = this.chance.evaluate(entity);
        class_1937 level = entity.method_73183();
        if ((double)level.field_9229.method_43057() < spawnChance) {
            int i = 0;
            while ((double)i < this.count.evaluate(entity)) {
                class_2394 po = this.getParticleOptions(entity);
                if (po == null) {
                    return;
                }
                Vector3f origin = new Vector3f((float)this.x.evaluate(entity), (float)this.y.evaluate(entity), (float)this.z.evaluate(entity));
                Vector3f speed = new Vector3f((float)this.dx.evaluate(entity), (float)this.dy.evaluate(entity), (float)this.dz.evaluate(entity));
                origin.mulPosition(transform);
                transform.transformDirection(speed);
                level.method_8406(po, (double)origin.x, (double)origin.y, (double)origin.z, (double)speed.x, (double)speed.y, (double)speed.z);
                ++i;
            }
        }
    }

    @Nullable
    private class_2394 getParticleOptions(class_1297 entity) {
        class_2400 st;
        class_2396 particleTypeValue = (class_2396)this.particleType.get().comp_349();
        if (Polytone.CUSTOM_PARTICLES.isDynamicParticle(((class_5321)this.particleType.get().method_40230().get()).method_29177())) {
            HashMap<String, Float> map = new HashMap<String, Float>();
            this.r.ifPresent(exp -> map.put("red", Float.valueOf((float)exp.evaluate(entity))));
            this.g.ifPresent(exp -> map.put("green", Float.valueOf((float)exp.evaluate(entity))));
            this.b.ifPresent(exp -> map.put("blue", Float.valueOf((float)exp.evaluate(entity))));
            this.a.ifPresent(exp -> map.put("alpha", Float.valueOf((float)exp.evaluate(entity))));
            this.roll.ifPresent(exp -> map.put("roll", Float.valueOf((float)exp.evaluate(entity))));
            this.size.ifPresent(exp -> map.put("size", Float.valueOf((float)exp.evaluate(entity))));
            this.custom.ifPresent(exp -> map.put("custom", Float.valueOf((float)exp.evaluate(entity))));
            return new ExtraDataParticleOptions(map, particleTypeValue);
        }
        if (!(particleTypeValue instanceof class_2400)) {
            Polytone.LOGGER.error("Unsupported particle type: {}", (Object)particleTypeValue);
            return null;
        }
        class_2400 po = st = (class_2400)particleTypeValue;
        return po;
    }

    @Nullable
    public class_4587 getSpawnPose(class_922<?, ?, ?> renderer) {
        if (this.bone.isEmpty()) {
            return new class_4587();
        }
        class_630 part = renderer.method_4038().method_63512();
        ArrayList<class_630> parts = new ArrayList<class_630>();
        parts.add(part);
        for (String b : this.bone) {
            part = (class_630)part.field_3661.get(b);
            if (part == null) {
                return null;
            }
            parts.add(part);
        }
        class_4587 poseStack = new class_4587();
        for (class_630 p : parts) {
            p.method_22703(poseStack);
        }
        return poseStack;
    }
}

