/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.content.fluid;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.LinkedListMultimap;
import com.google.gson.JsonElement;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.common.LegacyHelper;
import net.mehvahdjukaar.polytone.common.Parsed;
import net.mehvahdjukaar.polytone.common.Targets;
import net.mehvahdjukaar.polytone.common.reloader.JsonImgPartialReloader;
import net.mehvahdjukaar.polytone.common.struc.ArrayImage;
import net.mehvahdjukaar.polytone.content.colormap.Colormap;
import net.mehvahdjukaar.polytone.content.colormap.ColormapsManager;
import net.mehvahdjukaar.polytone.content.fluid.FluidPropertyModifier;
import net.mehvahdjukaar.polytone.content.fluid.fabric.FluidPropertiesManagerImpl;
import net.minecraft.class_1163;
import net.minecraft.class_2960;
import net.minecraft.class_322;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_6539;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7923;

public class FluidPropertiesManager
extends JsonImgPartialReloader {
    private final Map<class_3611, FluidPropertyModifier> modifiers = new HashMap<class_3611, FluidPropertyModifier>();
    private Map<class_2960, Parsed<FluidPropertyModifier>> extraModifiers;
    private Map<class_2960, ArrayImage> extraImages;
    private class_6539 vanillaWaterColorResolver = null;

    public FluidPropertiesManager() {
        super("fluid_modifiers", "fluid_properties");
    }

    public void addConvertedBlockProperties(Map<class_2960, Parsed<FluidPropertyModifier>> modifiers, Map<class_2960, ArrayImage> textures) {
        this.extraImages = textures;
        this.extraModifiers = modifiers;
    }

    @Override
    protected JsonImgPartialReloader.Resources prepare(class_3302.class_11558 sharedState) {
        class_3300 resourceManager = sharedState.method_72361();
        Map<class_2960, JsonElement> jsons = this.getJsonsInDirectories(resourceManager);
        HashMap<class_2960, ArrayImage> textures = new HashMap<class_2960, ArrayImage>();
        Map<class_2960, ArrayImage> cmTextures = ArrayImage.scanDirectory(resourceManager, "colormatic/colormap");
        textures.putAll(LegacyHelper.convertPaths(cmTextures));
        textures.putAll(this.getImagesInDirectories(resourceManager));
        return new JsonImgPartialReloader.Resources((Map<class_2960, JsonElement>)ImmutableMap.copyOf(jsons), (Map<class_2960, ArrayImage>)ImmutableMap.copyOf(textures));
    }

    @Override
    protected void parseWithLevel(JsonImgPartialReloader.Resources resources, class_6903<JsonElement> ops, class_7225.class_7874 access) {
        class_2960 id;
        Map<class_2960, JsonElement> jsons = resources.jsons();
        HashMap<class_2960, ArrayImage> textures = new HashMap<class_2960, ArrayImage>(resources.textures());
        HashSet<class_2960> usedTextures = new HashSet<class_2960>();
        LinkedListMultimap parsedModifiers = LinkedListMultimap.create();
        this.extraModifiers.forEach((arg_0, arg_1) -> ((LinkedListMultimap)parsedModifiers).put(arg_0, arg_1));
        textures.putAll(this.extraImages);
        for (Map.Entry<class_2960, Parsed<FluidPropertyModifier>> entry : Parsed.batchParseAlways(jsons, FluidPropertyModifier.CODEC, ops, "fluid modifier")) {
            id = entry.getKey();
            parsedModifiers.put((Object)id, entry.getValue());
        }
        for (Map.Entry<Object, Parsed<FluidPropertyModifier>> entry : parsedModifiers.entries()) {
            id = (class_2960)entry.getKey();
            Parsed<FluidPropertyModifier> parsed = entry.getValue();
            FluidPropertyModifier modifier = parsed.getResultOrPartial();
            if (!modifier.hasColormap() && textures.containsKey(id)) {
                modifier = modifier.merge(FluidPropertyModifier.ofBlockColor(Colormap.createDefTriangle()));
            }
            class_322 tint = modifier.getColormap();
            ColormapsManager.tryAcceptingTexture(textures, id, tint, usedTextures, true);
            if (!parsed.isEnabled()) continue;
            this.addModifier(id, modifier);
        }
        textures.keySet().removeAll(usedTextures);
        for (Map.Entry<Object, Object> entry : textures.entrySet()) {
            id = (class_2960)entry.getKey();
            Colormap defaultColormap = Colormap.createDefTriangle();
            ColormapsManager.tryAcceptingTexture(textures, id, (Object)defaultColormap, usedTextures, true);
            this.addModifier(id, new FluidPropertyModifier(Optional.of(defaultColormap), Optional.empty(), Targets.EMPTY));
        }
    }

    @Override
    protected void applyWithLevel(class_7225.class_7874 access, boolean isLogIn) {
        if (!this.modifiers.isEmpty()) {
            Polytone.LOGGER.info("Applied {} Fluid Modifiers", (Object)this.modifiers.size());
        }
    }

    @Override
    protected void resetWithLevel(boolean logOff) {
        this.modifiers.clear();
        FluidPropertiesManager.clearSpecial();
        if (this.vanillaWaterColorResolver != null) {
            class_1163.field_5666 = this.vanillaWaterColorResolver;
        }
        this.vanillaWaterColorResolver = null;
    }

    private void addModifier(class_2960 pathId, FluidPropertyModifier mod) {
        for (class_6880 fluid : mod.targets().compute(pathId, class_7923.field_41173)) {
            class_322 class_3222;
            class_3611 f = (class_3611)fluid.comp_349();
            this.modifiers.merge(f, mod, FluidPropertyModifier::merge);
            FluidPropertiesManager.tryAddSpecial(f, mod);
            if (fluid.comp_349() != class_3612.field_15910 || !((class_3222 = mod.getColormap()) instanceof class_6539)) continue;
            class_6539 c = (class_6539)class_3222;
            this.vanillaWaterColorResolver = class_1163.field_5666;
            class_1163.field_5666 = c;
        }
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static void tryAddSpecial(class_3611 fluid, FluidPropertyModifier colormap) {
        void var1_1;
        FluidPropertiesManagerImpl.tryAddSpecial(fluid, (FluidPropertyModifier)var1_1);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static void clearSpecial() {
        FluidPropertiesManagerImpl.clearSpecial();
    }

    public FluidPropertyModifier getModifier(class_3611 water) {
        return this.modifiers.get(water);
    }
}

