/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.content.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import net.mehvahdjukaar.polytone.common.Targets;
import net.mehvahdjukaar.polytone.common.struc.ListUtils;
import net.mehvahdjukaar.polytone.content.colormap.Colormap;
import net.mehvahdjukaar.polytone.content.colormap.IColorGetter;
import net.mehvahdjukaar.polytone.content.item.TooltipAddition;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_2561;
import net.minecraft.class_5699;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public record ItemModifier(Optional<IColorGetter> barColor, Optional<class_1814> rarity, List<TooltipAddition> tooltips, List<Pattern> removedTooltips, Targets targets) {
    public static final Codec<ItemModifier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Colormap.CODEC.optionalFieldOf("bar_color").forGetter(ItemModifier::barColor), (App)class_1814.field_50001.optionalFieldOf("rarity").forGetter(ItemModifier::rarity), (App)TooltipAddition.CODEC.listOf().optionalFieldOf("tooltips", List.of()).forGetter(ItemModifier::tooltips), (App)class_5699.field_37408.listOf().optionalFieldOf("removed_tooltips", List.of()).forGetter(ItemModifier::removedTooltips), (App)Targets.CODEC.optionalFieldOf("targets", (Object)Targets.EMPTY).forGetter(ItemModifier::targets)).apply((Applicative)instance, ItemModifier::new));

    public static ItemModifier ofBarColor(Colormap colormap) {
        return new ItemModifier(Optional.of(colormap), Optional.empty(), List.of(), List.of(), Targets.EMPTY);
    }

    public ItemModifier merge(ItemModifier newMod) {
        return new ItemModifier(newMod.barColor.isPresent() ? newMod.barColor : this.barColor, newMod.rarity.isPresent() ? newMod.rarity : this.rarity, ListUtils.mergeList(newMod.tooltips, this.tooltips), ListUtils.mergeList(newMod.removedTooltips, this.removedTooltips), newMod.targets.merge(this.targets));
    }

    public ItemModifier apply(class_1792 item) {
        class_1814 oldRarity = null;
        if (this.rarity.isPresent()) {
            class_9323 components = item.method_57347();
            oldRarity = (class_1814)components.method_58694(class_9334.field_50073);
            class_9323.class_9324 builder = class_9323.method_57827();
            builder.method_57839(components);
            builder.method_57840(class_9334.field_50073, (Object)this.rarity.get());
            item.field_49263 = builder.method_57838();
        }
        return new ItemModifier(Optional.empty(), Optional.ofNullable(oldRarity), List.of(), List.of(), Targets.EMPTY);
    }

    @Nullable
    public Integer getBarColor(class_1799 itemStack) {
        return this.barColor.map(c -> c.getItemColor(itemStack, 0)).orElse(null);
    }

    public IColorGetter getBarColor() {
        return this.barColor.orElse(null);
    }

    public boolean hasBarColor() {
        return this.barColor.isPresent();
    }

    public void modifyTooltips(List<class_2561> tooltips) {
        tooltips.removeIf(t -> this.removedTooltips.stream().anyMatch(p -> p.matcher(t.getString()).matches()));
        for (TooltipAddition ta : this.tooltips) {
            int position = ta.position();
            class_2561 tooltip = ta.component();
            if (position <= 0) {
                tooltips.addFirst(tooltip);
                continue;
            }
            if (position >= tooltips.size()) {
                tooltips.add(tooltip);
                continue;
            }
            tooltips.add(position, tooltip);
        }
    }

    public boolean shouldAttachToItem() {
        return !this.tooltips.isEmpty() || !this.removedTooltips.isEmpty() || this.barColor.isPresent();
    }
}

