/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.content.lightmap;

import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.ref.Cleaner;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.common.ColorUtils;
import net.mehvahdjukaar.polytone.common.codec.CodecUtils;
import net.mehvahdjukaar.polytone.common.struc.ArrayImage;
import net.mehvahdjukaar.polytone.content.dimension.DimensionTarget;
import net.mehvahdjukaar.polytone.content.lightmap.ILightmapNumberProvider;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_638;
import net.minecraft.class_765;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.lwjgl.system.MemoryUtil;

public class Lightmap {
    protected static final double DEFAULT_SKY_LERP = 0.1;
    protected static final double DEFAULT_TORCH_LERP = 0.0;
    protected static final float DEFAULT_BASE_LIGHT = 0.04f;
    public static final Codec<Lightmap> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)DimensionTarget.CODEC.optionalFieldOf("targets", (Object)DimensionTarget.EMPTY).forGetter(l -> l.targets), (App)ILightmapNumberProvider.CODEC.optionalFieldOf("sky_getter", (Object)ILightmapNumberProvider.DEFAULT).forGetter(l -> l.skyGetter), (App)ILightmapNumberProvider.CODEC.optionalFieldOf("torch_getter", (Object)ILightmapNumberProvider.DEFAULT).forGetter(l -> l.torchGetter), (App)Codec.BOOL.optionalFieldOf("lightning_strike_columns", (Object)true).forGetter(l -> l.hasLightningColumn), (App)Codec.doubleRange((double)0.0, (double)1.0).optionalFieldOf("sky_lerp_factor", (Object)0.1).forGetter(l -> l.skyLerp), (App)Codec.doubleRange((double)0.0, (double)1.0).optionalFieldOf("torch_lerp_factor", (Object)0.0).forGetter(l -> l.torchLerp), (App)Codec.FLOAT.optionalFieldOf("base_light", (Object)Float.valueOf(0.04f)).forGetter(l -> Float.valueOf(l.baseLight))).apply((Applicative)instance, Lightmap::new));
    public static final Codec<Lightmap> CODEC = CodecUtils.referenceOrDirect(Polytone.LIGHTMAPS.byNameCodec(), DIRECT_CODEC);
    private final DimensionTarget targets;
    private final ILightmapNumberProvider skyGetter;
    private final ILightmapNumberProvider torchGetter;
    private final boolean hasLightningColumn;
    private final float baseLight;
    private final double skyLerp;
    private final double torchLerp;
    private final ArrayImage[] textures = new ArrayImage[3];
    private final float[][] lastSkyLine = new float[16][3];
    private final float[][] lastTorchLine = new float[16][3];
    private final long lightmapPixels;
    private boolean lastThunderFlash = false;
    private long lastTime = 0L;
    private boolean forceUpload = false;

    public Lightmap(DimensionTarget targets, ILightmapNumberProvider skyGetter, ILightmapNumberProvider torchGetter, boolean lightningColumn, double skyLerp, double torchLerp, float baseLight) {
        this.skyGetter = skyGetter;
        this.torchGetter = torchGetter;
        this.hasLightningColumn = lightningColumn;
        this.skyLerp = skyLerp;
        this.torchLerp = torchLerp;
        this.baseLight = baseLight;
        long pixels = MemoryUtil.nmemAlloc((long)1024L);
        Cleaner.create().register(this, () -> MemoryUtil.nmemFree((long)pixels));
        this.lightmapPixels = pixels;
        this.targets = targets;
    }

    public Lightmap() {
        this(DimensionTarget.EMPTY, ILightmapNumberProvider.DEFAULT, ILightmapNumberProvider.RANDOM, true, 0.1, 0.0, 0.04f);
    }

    public void acceptImages(ArrayImage normal, ArrayImage rain, ArrayImage thunder) {
        this.textures[0] = normal;
        this.textures[1] = rain;
        this.textures[2] = thunder;
        for (ArrayImage v : this.textures) {
            if (v == null || v.width() > 2) continue;
            throw new IllegalStateException("Lightmap cannot have more with is too small! Was " + v.width());
        }
    }

    public DimensionTarget targets() {
        return this.targets;
    }

    public void forceRefresh() {
        this.forceUpload = true;
    }

    public void applyToLightTexture(class_765 instance, GpuTextureView lightmap, class_310 minecraft, class_638 level, float flicker, float partialTicks) {
    }

    public static void resetTextureUploadState() {
        GlStateManager._pixelStore((int)3314, (int)0);
        GlStateManager._pixelStore((int)3315, (int)0);
        GlStateManager._pixelStore((int)3316, (int)0);
        GlStateManager._pixelStore((int)3317, (int)4);
    }

    private float notGamma(float f) {
        float g = 1.0f - f;
        return 1.0f - g * g * g * g;
    }

    private float[][] selectSky(ArrayImage image, float nightVision, float time, float rain, float thunder, boolean isThunderFlash) {
        if (image == null) {
            return new float[0][];
        }
        double xVal = this.skyGetter.getValue(time, rain, thunder);
        float[][] skyLine = new float[16][];
        int usableSkyWidth = image.width() - 1 - (this.hasLightningColumn ? 1 : 0);
        int w = !isThunderFlash || !this.hasLightningColumn ? (isThunderFlash ? usableSkyWidth : Math.round((float)xVal * (float)usableSkyWidth)) : usableSkyWidth + 1;
        int h = nightVision != 0.0f && image.height() == 64 ? 32 : 0;
        for (int i = 0; i < 16; ++i) {
            skyLine[i] = ColorUtils.unpack(image.pixels()[h + i][w]);
        }
        return skyLine;
    }

    private float[][] selectTorch(ArrayImage image, float nightVision, float time, float rain, float thunder) {
        if (image == null || image.height() < 32) {
            return new float[0][];
        }
        double xVal = this.torchGetter.getValue(time, rain, thunder);
        float[][] torchLine = new float[16][];
        int h = 16 + (nightVision != 0.0f && image.height() == 64 ? 32 : 0);
        for (int i = 0; i < 16; ++i) {
            torchLine[i] = ColorUtils.unpack(image.pixels()[h + i][(int)(xVal * (double)(image.width() - 1))]);
        }
        return torchLine;
    }

    @Nullable
    private ArrayImage selectImage(float rain, float thunder) {
        ArrayImage image;
        if (thunder != 0.0f) {
            image = this.textures[2];
            if (image == null) {
                image = this.textures[0];
            }
        } else if (rain != 0.0f) {
            image = this.textures[1];
            if (image == null) {
                image = this.textures[0];
            }
        } else {
            image = this.textures[0];
        }
        return image;
    }

    private static void clampColor(Vector3f color) {
        color.set(class_3532.method_15363((float)color.x, (float)0.0f, (float)1.0f), class_3532.method_15363((float)color.y, (float)0.0f, (float)1.0f), class_3532.method_15363((float)color.z, (float)0.0f, (float)1.0f));
    }

    public static void lerpInplace(float[][] oldColors, float[][] newColors, float delta) {
        int i;
        if (oldColors.length != newColors.length || oldColors[0].length != newColors[0].length) {
            throw new IllegalArgumentException("Input arrays must have the same dimensions.");
        }
        int numRows = oldColors.length;
        int numCols = oldColors[0].length;
        for (i = 0; i < numRows; ++i) {
            for (int j = 0; j < numCols; ++j) {
                newColors[i][j] = class_3532.method_16439((float)delta, (float)oldColors[i][j], (float)newColors[i][j]);
            }
        }
        for (i = 0; i < numRows; ++i) {
            System.arraycopy(newColors[i], 0, oldColors[i], 0, numCols);
        }
    }
}

