/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.content.lightmap;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import net.mehvahdjukaar.polytone.common.ClientFrameTicker;
import net.mehvahdjukaar.polytone.common.ColorUtils;
import net.mehvahdjukaar.polytone.common.exp.ConcurrentExpression;
import net.mehvahdjukaar.polytone.common.exp.ExpressionUtils;
import net.mehvahdjukaar.polytone.common.exp.IExpression;
import net.mehvahdjukaar.polytone.content.lightmap.ILightmapNumberProvider;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_6880;
import net.objecthunter.exp4j.ExpressionBuilder;
import net.objecthunter.exp4j.function.Function;
import net.objecthunter.exp4j.operator.Operator;
import org.jetbrains.annotations.NotNull;

record LightmapContextExpression(ConcurrentExpression expression, String unparsed, boolean usesBiome) implements ILightmapNumberProvider
{
    public static final Codec<LightmapContextExpression> CODEC = Codec.STRING.flatXmap(s -> {
        try {
            return DataResult.success((Object)LightmapContextExpression.create(s));
        }
        catch (Exception e) {
            return DataResult.error(() -> "Failed to parse expression:" + e.getMessage());
        }
    }, exp -> DataResult.success((Object)exp.unparsed));
    private static final String TIME = "TIME";
    private static final String RAIN = "RAIN";
    private static final String THUNDER = "THUNDER";
    private static final String POS_X = "POS_X";
    private static final String POS_Y = "POS_Y";
    private static final String POS_Z = "POS_Z";
    private static final String TEMPERATURE = "TEMPERATURE";
    private static final String DOWNFALL = "DOWNFALL";

    public static LightmapContextExpression create(String s) {
        return new LightmapContextExpression(LightmapContextExpression.createExpression(s), s, s.contains(TEMPERATURE) || s.contains(DOWNFALL));
    }

    @NotNull
    private static ConcurrentExpression createExpression(String s) {
        return ConcurrentExpression.of(new ExpressionBuilder(ExpressionUtils.removeHex(s)).variables(new String[]{TIME, RAIN, THUNDER, DOWNFALL, TEMPERATURE}).functions(ExpressionUtils.defFunc(new Function[0])).operator(ExpressionUtils.defOp(new Operator[0])));
    }

    @Override
    public double getValue(float time, float rain, float thunder) {
        IExpression.IVars vb = this.expression.varBuilder();
        vb.setVariable(TIME, time);
        vb.setVariable(RAIN, rain);
        vb.setVariable(THUNDER, thunder);
        class_2338 pos = ClientFrameTicker.getCameraPos();
        vb.setVariable(POS_X, pos.method_10263());
        vb.setVariable(POS_Y, pos.method_10264());
        vb.setVariable(POS_Z, pos.method_10260());
        if (this.usesBiome) {
            class_6880<class_1959> biome = ClientFrameTicker.getCameraBiome();
            if (biome == null) {
                vb.setVariable(TEMPERATURE, 0.0);
                vb.setVariable(DOWNFALL, 0.0);
            } else {
                class_1959.class_5482 cs = ColorUtils.getClimateSettings((class_1959)biome.comp_349());
                vb.setVariable(TEMPERATURE, cs.comp_844);
                vb.setVariable(DOWNFALL, cs.comp_846);
            }
        }
        return this.expression.evaluate(vb);
    }
}

