/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.content.lightmap;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.serialization.Codec;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.mehvahdjukaar.polytone.PlatStuff;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.common.LegacyHelper;
import net.mehvahdjukaar.polytone.common.Parsed;
import net.mehvahdjukaar.polytone.common.Targets;
import net.mehvahdjukaar.polytone.common.reloader.JsonImgPartialReloader;
import net.mehvahdjukaar.polytone.common.struc.ArrayImage;
import net.mehvahdjukaar.polytone.common.struc.MapRegistry;
import net.mehvahdjukaar.polytone.content.lightmap.Lightmap;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_765;
import org.jetbrains.annotations.Nullable;

public class LightmapsManager
extends JsonImgPartialReloader {
    public static final class_2960 GUI_LIGHTMAP = Polytone.res("lightmaps/gui.png");
    private static final class_2960 DEFAULT_LIGHTMAP = class_2960.method_60656((String)"default");
    private static final Codec<Targets> TARGET_ONLY_CODEC = Targets.CODEC.optionalFieldOf("targets", (Object)Targets.EMPTY).codec();
    private final MapRegistry<Lightmap> lightmaps = new MapRegistry("Lightmaps");
    private final Map<class_5321<class_1959>, Lightmap> biomeLightmaps = new HashMap<class_5321<class_1959>, Lightmap>();
    private class_5321<class_1937> lastDimension = null;
    private Lightmap currentLightmap = null;
    private boolean reachedMainMenuHack = false;
    private boolean usingGuiLightmap = false;

    public LightmapsManager() {
        super("lightmaps");
    }

    @Override
    protected JsonImgPartialReloader.Resources prepare(class_3302.class_11558 sharedState) {
        class_3300 resourceManager = sharedState.method_72361();
        Map<class_2960, JsonElement> jsons = this.getJsonsInDirectories(resourceManager);
        HashMap<class_2960, ArrayImage> textures = new HashMap<class_2960, ArrayImage>();
        Map<class_2960, ArrayImage> ofTextures = ArrayImage.scanDirectory(resourceManager, "optifine/lightmap");
        Map<class_2960, ArrayImage> cmTextures = ArrayImage.scanDirectory(resourceManager, "colormatic/lightmap");
        textures.putAll(LegacyHelper.convertPaths(ofTextures));
        textures.putAll(LegacyHelper.convertPaths(cmTextures));
        textures.putAll(this.getImagesInDirectories(resourceManager));
        return new JsonImgPartialReloader.Resources((Map<class_2960, JsonElement>)ImmutableMap.copyOf(jsons), (Map<class_2960, ArrayImage>)ImmutableMap.copyOf(textures));
    }

    @Override
    protected void parseWithLevel(JsonImgPartialReloader.Resources resources, class_6903<JsonElement> ops, class_7225.class_7874 access) {
        Map<class_2960, ArrayImage> images = resources.textures();
        HashMap<class_2960, JsonElement> jsons = new HashMap<class_2960, JsonElement>(resources.jsons());
        this.lastDimension = null;
        this.currentLightmap = null;
        HashMap<class_2960, Map> grouped = new HashMap<class_2960, Map>();
        for (Map.Entry<class_2960, ArrayImage> entry : images.entrySet()) {
            ArrayImage value = entry.getValue();
            int height = value.height();
            class_2960 location = entry.getKey();
            if (height != 16 && height != 32 && height != 64) {
                throw new IllegalStateException("Lightmap must be either 16, 32 or 64 pixels tall. Provided one at " + String.valueOf(location) + " was " + height + " pixels");
            }
            String path = location.method_12832();
            if (path.endsWith("_thunder")) {
                grouped.computeIfAbsent(location.method_45136(path.replace("_thunder", "")), g -> new HashMap()).put("thunder", value);
                continue;
            }
            if (path.endsWith("_rain")) {
                grouped.computeIfAbsent(location.method_45136(path.replace("_rain", "")), g -> new HashMap()).put("rain", value);
                continue;
            }
            grouped.computeIfAbsent(location, g -> new HashMap()).put("normal", value);
        }
        for (Map.Entry<Object, ArrayImage> entry : grouped.entrySet()) {
            class_2960 location = (class_2960)entry.getKey();
            JsonElement j = jsons.remove(location);
            Parsed<Lightmap> parsed = j != null ? Parsed.parseAlways(Lightmap.CODEC, j, ops, location, "lightmap") : Parsed.success(new Lightmap(), location);
            Lightmap lightmap = parsed.getResultOrPartial();
            Map map = (Map)((Object)entry.getValue());
            lightmap.acceptImages((ArrayImage)map.get("normal"), (ArrayImage)map.get("rain"), (ArrayImage)map.get("thunder"));
            if (!parsed.isEnabled()) continue;
            this.addLightmap(location, lightmap, access);
        }
        if (!jsons.isEmpty()) {
            throw new IllegalStateException("Found some lightmaps .jsons with no associated textures at" + String.valueOf(jsons));
        }
    }

    private void addLightmap(class_2960 fileId, Lightmap mod, class_7225.class_7874 access) {
        for (class_6880<class_2874> dim : mod.targets().compute(fileId, access)) {
            this.lightmaps.register(((class_5321)dim.method_40230().get()).method_29177(), mod);
        }
    }

    @Override
    protected void applyWithLevel(class_7225.class_7874 access, boolean isLogIn) {
    }

    @Override
    protected void resetWithLevel(boolean logOff) {
        this.lightmaps.clear();
    }

    public boolean maybeModifyLightTexture(class_765 instance, GpuTextureView lightmap, class_310 minecraft, class_638 level, float flicker, float partialTicks) {
        return false;
    }

    public void setupForGUI(boolean gui) {
        this.usingGuiLightmap = gui;
    }

    public boolean isGui() {
        if (!this.reachedMainMenuHack && !PlatStuff.isModStateValid()) {
            return false;
        }
        return this.usingGuiLightmap;
    }

    public Codec<Lightmap> byNameCodec() {
        return this.lightmaps;
    }

    @Nullable
    private Lightmap findLightmapForLevel(class_1937 level) {
        class_6880 currentDimHolder = level.method_40134();
        class_5455 access = level.method_30349();
        for (Map.Entry<class_2960, Lightmap> v : this.lightmaps.getEntries()) {
            class_2960 modId = v.getKey();
            Lightmap modifier = v.getValue();
            Collection<class_6880<class_2874>> targets = modifier.targets().compute(modId, (class_7225.class_7874)access);
            if (!targets.contains(currentDimHolder)) continue;
            return modifier;
        }
        return null;
    }
}

