/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.content.particle;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Locale;
import java.util.Optional;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.common.codec.BiggerCodecs;
import net.mehvahdjukaar.polytone.common.codec.CodecUtils;
import net.mehvahdjukaar.polytone.common.expressions.impl.IBlockExp;
import net.mehvahdjukaar.polytone.content.block.BlockClientTickable;
import net.mehvahdjukaar.polytone.content.block.TickSource;
import net.mehvahdjukaar.polytone.content.particle.custom.CustomParticleType;
import net.mehvahdjukaar.polytone.content.particle.custom.ExtraDataParticleOptions;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2388;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_3818;
import net.minecraft.class_3825;
import net.minecraft.class_4538;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public record BlockParticleEmitter(Optional<class_6880<class_2396<?>>> particleType, IBlockExp chance, IBlockExp count, IBlockExp x, IBlockExp y, IBlockExp z, IBlockExp dx, IBlockExp dy, IBlockExp dz, Optional<IBlockExp> r, Optional<IBlockExp> g, Optional<IBlockExp> b, Optional<IBlockExp> a, Optional<IBlockExp> roll, Optional<IBlockExp> size, Optional<IBlockExp> custom, class_3825 predicate, Optional<class_6885<class_1959>> biomes, SpawnLocation spawnLocation, TickSource spawnSource) implements BlockClientTickable
{
    public static final Codec<BlockParticleEmitter> CODEC = RecordCodecBuilder.create(i -> BiggerCodecs.group(i, CodecUtils.forwardAwareHolderByNameCodec(class_7923.field_41180).fieldOf("particle").forGetter(BlockParticleEmitter::particleType), IBlockExp.CODEC.optionalFieldOf("chance", (Object)IBlockExp.ONE).forGetter(BlockParticleEmitter::chance), IBlockExp.CODEC.optionalFieldOf("count", (Object)IBlockExp.ONE).forGetter(BlockParticleEmitter::count), IBlockExp.CODEC.optionalFieldOf("x", (Object)IBlockExp.PARTICLE_RAND).forGetter(BlockParticleEmitter::x), IBlockExp.CODEC.optionalFieldOf("y", (Object)IBlockExp.PARTICLE_RAND).forGetter(BlockParticleEmitter::y), IBlockExp.CODEC.optionalFieldOf("z", (Object)IBlockExp.PARTICLE_RAND).forGetter(BlockParticleEmitter::z), IBlockExp.CODEC.optionalFieldOf("dx", (Object)IBlockExp.ZERO).forGetter(BlockParticleEmitter::dx), IBlockExp.CODEC.optionalFieldOf("dy", (Object)IBlockExp.ZERO).forGetter(BlockParticleEmitter::dy), IBlockExp.CODEC.optionalFieldOf("dz", (Object)IBlockExp.ZERO).forGetter(BlockParticleEmitter::dz), IBlockExp.CODEC.optionalFieldOf("red").forGetter(BlockParticleEmitter::r), IBlockExp.CODEC.optionalFieldOf("green").forGetter(BlockParticleEmitter::g), IBlockExp.CODEC.optionalFieldOf("blue").forGetter(BlockParticleEmitter::b), IBlockExp.CODEC.optionalFieldOf("alpha").forGetter(BlockParticleEmitter::a), IBlockExp.CODEC.optionalFieldOf("roll").forGetter(BlockParticleEmitter::roll), IBlockExp.CODEC.optionalFieldOf("size").forGetter(BlockParticleEmitter::size), IBlockExp.CODEC.optionalFieldOf("custom").forGetter(BlockParticleEmitter::custom), CodecUtils.lenientWithLog(class_3825.field_25012, "state_predicate", class_3818.field_16868).forGetter(BlockParticleEmitter::predicate), CodecUtils.forwardAwareHomogeneousList(class_7924.field_41236).optionalFieldOf("biomes").forGetter(BlockParticleEmitter::biomes), SpawnLocation.CODEC.optionalFieldOf("spawn_location", (Object)SpawnLocation.CENTER).forGetter(BlockParticleEmitter::spawnLocation), TickSource.CODEC.optionalFieldOf("tick_source", (Object)TickSource.ANIMATE_TICK).forGetter(BlockParticleEmitter::spawnSource)).apply(i, BlockParticleEmitter::new));

    @Override
    public void tick(class_1937 level, class_2338 pos, class_2680 state, TickSource source) {
        if (this.particleType.isEmpty()) {
            return;
        }
        if (source != this.spawnSource) {
            return;
        }
        double spawnChance = this.chance.evaluate((class_4538)level, pos, state);
        if ((double)level.field_9229.method_43057() < spawnChance && this.predicate().method_16768(state, level.field_9229)) {
            if (this.biomes.isPresent()) {
                class_6880 biome = level.method_23753(pos);
                if (!this.biomes.get().method_40241(biome)) {
                    return;
                }
            }
            int i = 0;
            while ((double)i < this.count.evaluate((class_4538)level, pos, state)) {
                CustomParticleType.setStateHack(state);
                class_2394 po = this.getParticleOptions(level, pos, state);
                if (po == null) {
                    return;
                }
                class_243 pp = this.spawnLocation.getLocation(pos, state, level.field_9229);
                level.method_8494(po, pp.method_10216() + this.x.evaluate((class_4538)level, pos, state), pp.method_10214() + this.y.evaluate((class_4538)level, pos, state), pp.method_10215() + this.z.evaluate((class_4538)level, pos, state), this.dx.evaluate((class_4538)level, pos, state), this.dy.evaluate((class_4538)level, pos, state), this.dz.evaluate((class_4538)level, pos, state));
                ++i;
            }
        }
    }

    @Nullable
    private class_2394 getParticleOptions(class_1937 level, class_2338 pos, class_2680 state) {
        class_2400 po;
        class_2396 particleTypeValue = (class_2396)this.particleType.get().comp_349();
        if (Polytone.CUSTOM_PARTICLES.isDynamicParticle(((class_5321)this.particleType.get().method_40230().get()).method_29177())) {
            HashMap<String, Float> map = new HashMap<String, Float>();
            this.r.ifPresent(exp -> map.put("red", Float.valueOf((float)exp.evaluate((class_4538)level, pos, state))));
            this.g.ifPresent(exp -> map.put("green", Float.valueOf((float)exp.evaluate((class_4538)level, pos, state))));
            this.b.ifPresent(exp -> map.put("blue", Float.valueOf((float)exp.evaluate((class_4538)level, pos, state))));
            this.a.ifPresent(exp -> map.put("alpha", Float.valueOf((float)exp.evaluate((class_4538)level, pos, state))));
            this.roll.ifPresent(exp -> map.put("roll", Float.valueOf((float)exp.evaluate((class_4538)level, pos, state))));
            this.size.ifPresent(exp -> map.put("size", Float.valueOf((float)exp.evaluate((class_4538)level, pos, state))));
            this.custom.ifPresent(exp -> map.put("custom", Float.valueOf((float)exp.evaluate((class_4538)level, pos, state))));
            return new ExtraDataParticleOptions(map, particleTypeValue);
        }
        if (particleTypeValue instanceof class_2400) {
            class_2400 st;
            po = st = (class_2400)particleTypeValue;
        } else if (particleTypeValue == class_2398.field_11217 || particleTypeValue == class_2398.field_11206 || particleTypeValue == class_2398.field_35434 || particleTypeValue == class_2398.field_50248) {
            po = new class_2388(particleTypeValue, state);
        } else if (particleTypeValue == class_2398.field_11218) {
            po = new class_2392(particleTypeValue, state.method_26204().method_8389().method_7854());
        } else {
            Polytone.LOGGER.error("Unsupported particle type: {}", (Object)particleTypeValue);
            return null;
        }
        return po;
    }

    public static class_243 getParticleSpawnPosOnFace(class_5819 random, class_2338 pos, class_2350 direction) {
        class_243 vec3 = class_243.method_24953((class_2382)pos);
        int i = direction.method_10148();
        int j = direction.method_10164();
        int k = direction.method_10165();
        double d0 = vec3.field_1352 + (i == 0 ? class_3532.method_15366((class_5819)random, (double)-0.5, (double)0.5) : (double)i * 0.6);
        double d1 = vec3.field_1351 + (j == 0 ? class_3532.method_15366((class_5819)random, (double)-0.5, (double)0.5) : (double)j * 0.6);
        double d2 = vec3.field_1350 + (k == 0 ? class_3532.method_15366((class_5819)random, (double)-0.5, (double)0.5) : (double)k * 0.6);
        return new class_243(d0, d1, d2);
    }

    public static enum SpawnLocation implements class_3542
    {
        CENTER,
        LOWER_CORNER,
        BLOCK_FACES;

        public static final Codec<SpawnLocation> CODEC;

        public String method_15434() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        class_243 getLocation(class_2338 pos, class_2680 state, class_5819 rand) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 1 -> class_243.method_24954((class_2382)pos);
                case 0 -> class_243.method_24953((class_2382)pos);
                case 2 -> {
                    class_2350 dir = class_2350.values()[rand.method_43048(class_2350.values().length)];
                    yield BlockParticleEmitter.getParticleSpawnPosOnFace(rand, pos, dir);
                }
            };
        }

        static {
            CODEC = class_3542.method_28140(SpawnLocation::values);
        }
    }
}

