/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.content.particle.custom;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.mehvahdjukaar.polytone.PolytoneRenderTypes;
import net.mehvahdjukaar.polytone.SpecialModelsHandler;
import net.mehvahdjukaar.polytone.common.ColorUtils;
import net.mehvahdjukaar.polytone.common.codec.BiggerCodecs;
import net.mehvahdjukaar.polytone.common.expressions.impl.IParticleExp;
import net.mehvahdjukaar.polytone.content.colormap.Colormap;
import net.mehvahdjukaar.polytone.content.colormap.IColorGetter;
import net.mehvahdjukaar.polytone.content.particle.ParticleParticleEmitter;
import net.mehvahdjukaar.polytone.content.particle.custom.CustomParticleFactory;
import net.mehvahdjukaar.polytone.content.particle.custom.ExtraDataParticleOptions;
import net.mehvahdjukaar.polytone.content.particle.custom.LiquidAffinity;
import net.mehvahdjukaar.polytone.content.particle.custom.ParticleInitializer;
import net.mehvahdjukaar.polytone.content.particle.custom.ParticleRenderMode;
import net.mehvahdjukaar.polytone.content.particle.custom.ParticleTickable;
import net.mehvahdjukaar.polytone.content.particle.custom.RotationMode;
import net.mehvahdjukaar.polytone.content.particle.custom.RotationProvider;
import net.mehvahdjukaar.polytone.content.particle.custom.render.ModelParticleRenderState;
import net.mehvahdjukaar.polytone.content.sound.ParticleSoundEmitter;
import net.minecraft.class_10817;
import net.minecraft.class_11938;
import net.minecraft.class_11944;
import net.minecraft.class_12249;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3940;
import net.minecraft.class_3999;
import net.minecraft.class_4002;
import net.minecraft.class_4184;
import net.minecraft.class_5699;
import net.minecraft.class_5819;
import net.minecraft.class_5878;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_765;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;

public class CustomParticleType
implements CustomParticleFactory {
    private static class_2680 STATE_HACK = class_2246.field_10124.method_9564();
    private final ParticleRenderMode renderType;
    @Nullable
    private final class_2960 model;
    @Nullable
    private final ParticleInitializer initializer;
    @Nullable
    private final Ticker ticker;
    private final List<ParticleSoundEmitter> sounds;
    private final int tickRate;
    private final int exclusionRadius;
    protected final List<ParticleParticleEmitter> particles = new ArrayList<ParticleParticleEmitter>();
    @Nullable
    protected List<Dynamic<?>> lazyParticles;
    private final int lightLevel;
    private final LiquidAffinity liquidAffinity;
    private final boolean hasPhysics;
    private final boolean killOnContact;
    private final boolean killWhenStill;
    @Nullable
    private final IColorGetter colormap;
    private final RotationProvider rotationProvider;
    private final class_243 offset;
    private final Optional<class_5878> particleGroupLimit;
    private final boolean forceSpawn;
    private final boolean randomSprite;
    private transient class_4002 spriteSet;
    private boolean isValid = true;
    public static final Codec<CustomParticleType> CODEC = RecordCodecBuilder.create(i -> BiggerCodecs.group(i, ParticleRenderMode.CODEC.optionalFieldOf("render_type", (Object)ParticleRenderMode.OPAQUE).forGetter(CustomParticleType::getRenderType), RotationProvider.CODEC.optionalFieldOf("rotation_mode", (Object)RotationMode.LOOK_AT_XYZ).forGetter(c -> c.rotationProvider), class_2960.field_25139.optionalFieldOf("model").forGetter(c -> Optional.ofNullable(c.model)), class_243.field_38277.optionalFieldOf("offset", (Object)class_243.field_1353).forGetter(c -> c.offset), Codec.intRange((int)0, (int)15).optionalFieldOf("light_level", (Object)0).forGetter(c -> c.lightLevel), Codec.BOOL.optionalFieldOf("has_physics", (Object)true).forGetter(c -> c.hasPhysics), Codec.BOOL.optionalFieldOf("kill_on_contact", (Object)false).forGetter(c -> c.killOnContact), Codec.BOOL.optionalFieldOf("kill_when_still", (Object)false).forGetter(c -> c.killWhenStill), LiquidAffinity.CODEC.optionalFieldOf("liquid_affinity", (Object)LiquidAffinity.ANY).forGetter(c -> c.liquidAffinity), Colormap.CODEC.optionalFieldOf("colormap").forGetter(c -> Optional.ofNullable(c.colormap)), Codec.BOOL.optionalFieldOf("random_sprite", (Object)false).forGetter(c -> c.randomSprite), class_5699.field_33441.optionalFieldOf("limit", (Object)0).forGetter(c -> c.particleGroupLimit.map(class_5878::comp_4820).orElse(0)), Codec.BOOL.optionalFieldOf("force_spawn", (Object)false).forGetter(c -> c.forceSpawn), ParticleInitializer.CODEC.optionalFieldOf("initializer").forGetter(c -> Optional.ofNullable(c.initializer)), Ticker.CODEC.optionalFieldOf("ticker").forGetter(c -> Optional.ofNullable(c.ticker)), ParticleSoundEmitter.CODEC.listOf().optionalFieldOf("sound_emitters", List.of()).forGetter(c -> c.sounds), class_5699.field_33442.optionalFieldOf("tick_interval", (Object)1).forGetter(c -> c.tickRate), Codec.PASSTHROUGH.listOf().optionalFieldOf("particle_emitters", List.of()).forGetter(c -> c.lazyParticles), class_5699.field_33441.optionalFieldOf("exclusion_radius", (Object)0).forGetter(c -> c.exclusionRadius)).apply(i, CustomParticleType::new));
    public static final Codec<Optional<class_2960>> CUSTOM_MODEL_ONLY_CODEC = RecordCodecBuilder.create(i -> i.group((App)class_2960.field_25139.optionalFieldOf("model").forGetter(e -> e)).apply((Applicative)i, r -> r));

    private CustomParticleType(ParticleRenderMode renderType, RotationProvider rotationProvider, @Nullable class_2960 model, class_243 offset, int light, boolean hasPhysics, boolean killOnContact, boolean killWhenStill, LiquidAffinity liquidAffinity, @Nullable IColorGetter colormap, boolean randomSprite, int particleGroupLimit, boolean forceSpawn, @Nullable ParticleInitializer initializer, @Nullable Ticker ticker, @Nullable List<ParticleSoundEmitter> sounds, int tickRate, @Nullable List<Dynamic<?>> particles, int killSimilarInRadius) {
        this.renderType = renderType;
        this.randomSprite = randomSprite;
        this.model = model;
        this.initializer = initializer;
        this.ticker = ticker;
        this.sounds = sounds;
        this.lazyParticles = particles;
        this.lightLevel = light;
        this.hasPhysics = hasPhysics;
        this.killOnContact = killOnContact;
        this.killWhenStill = killWhenStill;
        this.liquidAffinity = liquidAffinity;
        this.forceSpawn = forceSpawn;
        this.colormap = colormap;
        this.offset = offset;
        this.rotationProvider = rotationProvider;
        this.tickRate = tickRate;
        this.exclusionRadius = killSimilarInRadius;
        this.particleGroupLimit = particleGroupLimit > 0 ? Optional.of(new class_5878(particleGroupLimit)) : Optional.empty();
    }

    private CustomParticleType(ParticleRenderMode renderType, RotationProvider rotationProvider, Optional<class_2960> model, class_243 offset, int light, boolean hasPhysics, boolean killOnContact, boolean killWhenStill, LiquidAffinity liquidAffinity, Optional<IColorGetter> colormap, boolean randomSprite, int limit, boolean forceSpawn, Optional<ParticleInitializer> initializer, Optional<Ticker> ticker, List<ParticleSoundEmitter> sounds, int tickRate, List<Dynamic<?>> particles, int killSimilarInRadius) {
        this(renderType, rotationProvider, (class_2960)model.orElse(null), offset, light, hasPhysics, killOnContact, killWhenStill, liquidAffinity, (IColorGetter)colormap.orElse(null), randomSprite, limit, forceSpawn, (ParticleInitializer)initializer.orElse(null), (Ticker)ticker.orElse(null), sounds, tickRate, particles, killSimilarInRadius);
    }

    @Override
    public boolean forceSpawns() {
        return this.forceSpawn;
    }

    @Override
    @Nullable
    public class_2960 getCustomModel() {
        return this.model;
    }

    public static void setStateHack(class_2680 state) {
        STATE_HACK = state;
    }

    private ParticleRenderMode getRenderType() {
        return this.renderType;
    }

    @Override
    public class_703 createParticleWithState(ExtraDataParticleOptions opt, class_638 world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, @Nullable class_2680 state, class_5819 random) {
        if (this.spriteSet != null) {
            Instance newParticle = new Instance(world, x, y, z, xSpeed, ySpeed, zSpeed, state, this, random);
            opt.apply(newParticle);
            if (this.hasPhysics) {
                for (class_265 voxelShape : world.method_20812(null, newParticle.method_3064())) {
                    if (voxelShape.method_1110()) continue;
                    return null;
                }
            }
            if (this.ticker != null && this.ticker.removeIf != null && this.ticker.removeIf.evaluate((class_703)newParticle, (class_1937)world) > 0.0) {
                return null;
            }
            if (this.exclusionRadius > 0) {
                class_3999 particleRenderType = this.getParticleGroup();
                double radiusSquared = this.exclusionRadius * this.exclusionRadius;
                class_11938 particleQueue = (class_11938)class_310.method_1551().field_1713.field_3830.get(particleRenderType);
                if (particleQueue != null) {
                    for (class_703 p : particleQueue.method_74290()) {
                        double distSqrt;
                        if (!(p instanceof Instance)) continue;
                        Instance inst = (Instance)p;
                        if (inst.type != this || !((distSqrt = class_3532.method_41190((double)(inst.field_3874 - newParticle.field_3874), (double)(inst.field_3854 - newParticle.field_3854), (double)(inst.field_3871 - newParticle.field_3871))) < radiusSquared)) continue;
                        if (inst.hasAgeLeft()) {
                            return null;
                        }
                        inst.method_3085();
                    }
                }
            }
            return newParticle;
        }
        throw new IllegalStateException("Sprite set not set for custom particle type");
    }

    private class_3999 getParticleGroup() {
        if (this.renderType == ParticleRenderMode.INVISIBLE) {
            return class_3999.field_17832;
        }
        return this.model != null ? PolytoneRenderTypes.PARTICLE_MODEL_GROUP : class_3999.field_62622;
    }

    @Override
    public void setSpriteSet(class_4002 spriteSet) {
        this.spriteSet = spriteSet;
    }

    public void setUnregistered() {
        this.isValid = false;
    }

    protected record Ticker(@Nullable IParticleExp x, @Nullable IParticleExp y, @Nullable IParticleExp z, @Nullable IParticleExp dx, @Nullable IParticleExp dy, @Nullable IParticleExp dz, @Nullable IParticleExp size, @Nullable IParticleExp red, @Nullable IParticleExp green, @Nullable IParticleExp blue, @Nullable IParticleExp alpha, @Nullable IParticleExp roll, @Nullable IParticleExp custom, @Nullable IParticleExp removeIf) {
        private static final Codec<Ticker> CODEC = RecordCodecBuilder.create(i -> i.group((App)IParticleExp.CODEC.optionalFieldOf("x").forGetter(p -> Optional.ofNullable(p.x)), (App)IParticleExp.CODEC.optionalFieldOf("y").forGetter(p -> Optional.ofNullable(p.y)), (App)IParticleExp.CODEC.optionalFieldOf("z").forGetter(p -> Optional.ofNullable(p.z)), (App)IParticleExp.CODEC.optionalFieldOf("dx").forGetter(p -> Optional.ofNullable(p.dx)), (App)IParticleExp.CODEC.optionalFieldOf("dy").forGetter(p -> Optional.ofNullable(p.dy)), (App)IParticleExp.CODEC.optionalFieldOf("dz").forGetter(p -> Optional.ofNullable(p.dz)), (App)IParticleExp.CODEC.optionalFieldOf("size").forGetter(p -> Optional.ofNullable(p.size)), (App)IParticleExp.CODEC.optionalFieldOf("red").forGetter(p -> Optional.ofNullable(p.red)), (App)IParticleExp.CODEC.optionalFieldOf("green").forGetter(p -> Optional.ofNullable(p.green)), (App)IParticleExp.CODEC.optionalFieldOf("blue").forGetter(p -> Optional.ofNullable(p.blue)), (App)IParticleExp.CODEC.optionalFieldOf("alpha").forGetter(p -> Optional.ofNullable(p.alpha)), (App)IParticleExp.CODEC.optionalFieldOf("roll").forGetter(p -> Optional.ofNullable(p.roll)), (App)IParticleExp.CODEC.optionalFieldOf("custom").forGetter(p -> Optional.ofNullable(p.custom)), (App)IParticleExp.CODEC.optionalFieldOf("remove_condition").forGetter(p -> Optional.ofNullable(p.removeIf))).apply((Applicative)i, Ticker::new));

        private Ticker(Optional<IParticleExp> x, Optional<IParticleExp> y, Optional<IParticleExp> z, Optional<IParticleExp> dx, Optional<IParticleExp> dy, Optional<IParticleExp> dz, Optional<IParticleExp> size, Optional<IParticleExp> red, Optional<IParticleExp> green, Optional<IParticleExp> blue, Optional<IParticleExp> alpha, Optional<IParticleExp> roll, Optional<IParticleExp> custom, Optional<IParticleExp> removeIf) {
            this((IParticleExp)x.orElse(null), (IParticleExp)y.orElse(null), (IParticleExp)z.orElse(null), (IParticleExp)dx.orElse(null), (IParticleExp)dy.orElse(null), (IParticleExp)dz.orElse(null), (IParticleExp)size.orElse(null), (IParticleExp)red.orElse(null), (IParticleExp)green.orElse(null), (IParticleExp)blue.orElse(null), (IParticleExp)alpha.orElse(null), (IParticleExp)roll.orElse(null), (IParticleExp)custom.orElse(null), (IParticleExp)removeIf.orElse(null));
        }

        private void tick(Instance particle, class_638 level) {
            if (this.roll != null) {
                particle.field_62637 = (float)this.roll.evaluate((class_703)particle, (class_1937)level);
            }
            if (this.size != null) {
                particle.field_17867 = (float)this.size.evaluate((class_703)particle, (class_1937)level);
            }
            if (this.red != null) {
                particle.field_62633 = (float)this.red.evaluate((class_703)particle, (class_1937)level);
            }
            if (this.green != null) {
                particle.field_62634 = (float)this.green.evaluate((class_703)particle, (class_1937)level);
            }
            if (this.blue != null) {
                particle.field_62635 = (float)this.blue.evaluate((class_703)particle, (class_1937)level);
            }
            if (this.alpha != null) {
                particle.field_62636 = (float)this.alpha.evaluate((class_703)particle, (class_1937)level);
            }
            if (this.x != null) {
                particle.field_3874 = this.x.evaluate((class_703)particle, (class_1937)level);
            }
            if (this.y != null) {
                particle.field_3854 = this.y.evaluate((class_703)particle, (class_1937)level);
            }
            if (this.z != null) {
                particle.field_3871 = this.z.evaluate((class_703)particle, (class_1937)level);
            }
            if (this.dx != null) {
                particle.field_3852 = this.dx.evaluate((class_703)particle, (class_1937)level);
            }
            if (this.dy != null) {
                particle.field_3869 = this.dy.evaluate((class_703)particle, (class_1937)level);
            }
            if (this.dz != null) {
                particle.field_3850 = this.dz.evaluate((class_703)particle, (class_1937)level);
            }
            if (this.custom != null) {
                particle.custom = this.custom.evaluate((class_703)particle, (class_1937)level);
            }
            if (this.removeIf != null && this.removeIf.evaluate((class_703)particle, (class_1937)level) > 0.0) {
                particle.method_3085();
            }
        }
    }

    public static class Instance
    extends class_3940 {
        protected final CustomParticleType type;
        @Nullable
        protected final class_10817 model;
        protected final class_4002 spriteSet;
        protected final LiquidAffinity liquidAffinity;
        protected final List<ParticleTickable> tickables;
        protected float oQuadSize;
        protected double custom;

        protected Instance(class_638 level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, @Nullable class_2680 state, CustomParticleType customType, class_5819 random) {
            super(level, x, y, z, xSpeed, ySpeed, zSpeed, customType.randomSprite ? customType.spriteSet.method_18139(random) : customType.spriteSet.method_74304());
            if (customType.randomSprite) {
                this.spriteSet = null;
                this.method_74307(customType.spriteSet.method_18139(random));
            } else {
                this.spriteSet = customType.spriteSet;
                this.method_74306(this.spriteSet);
            }
            this.method_3080(0.1f, 0.1f);
            this.type = customType;
            this.tickables = new ArrayList<ParticleTickable>();
            this.tickables.addAll(customType.sounds);
            this.tickables.addAll(customType.particles);
            if (state == null) {
                state = STATE_HACK;
            }
            this.field_3874 = x;
            this.field_3854 = y;
            this.field_3871 = z;
            this.field_3852 = xSpeed;
            this.field_3869 = ySpeed;
            this.field_3850 = zSpeed;
            this.model = customType.model == null ? null : SpecialModelsHandler.getSpecialModel(customType.model);
            ParticleInitializer initializer = customType.initializer;
            class_2338 pos = class_2338.method_49637((double)x, (double)y, (double)z);
            if (initializer != null) {
                initializer.initialize(this, level, state, pos);
            }
            this.oQuadSize = this.field_17867;
            this.liquidAffinity = customType.liquidAffinity;
            this.field_3862 = customType.hasPhysics;
            if (this.type.colormap != null) {
                float[] unpack = ColorUtils.unpack(this.type.colormap.getColor(state, (class_1920)level, pos, 0));
                this.method_74305(unpack[0], unpack[1], unpack[2]);
            }
        }

        private boolean hasAgeLeft() {
            return this.field_3866 < this.field_3847;
        }

        public double getCustom() {
            return this.custom;
        }

        @NotNull
        public Optional<class_5878> method_34019() {
            return this.type.particleGroupLimit;
        }

        public class_3940.class_8981 method_55245() {
            return this.type.rotationProvider;
        }

        public void method_3074(class_11944 quadParticleRenderState, class_4184 camera, float f) {
            Quaternionf quaternionf = new Quaternionf();
            this.type.rotationProvider.setRotation(this, quaternionf, camera, f);
            if (this.field_62637 != 0.0f) {
                quaternionf.rotateZ(class_3532.method_16439((float)f, (float)this.field_62638, (float)this.field_62637));
            }
            this.method_60373(quadParticleRenderState, camera, quaternionf, f);
            if (!this.type.rotationProvider.alwaysFacesCamera() && this.model == null) {
                quaternionf.rotateX((float)Math.PI);
                this.method_60373(quadParticleRenderState, camera, quaternionf, f);
            }
        }

        public void extractModel(ModelParticleRenderState modelParticleRenderState, class_4184 camera, float f) {
            Quaternionf quaternionf = new Quaternionf();
            this.type.rotationProvider.setRotation(this, quaternionf, camera, f);
            if (this.field_62637 != 0.0f) {
                quaternionf.rotateZ(class_3532.method_16439((float)f, (float)this.field_62638, (float)this.field_62637));
            }
            class_243 offset = this.type.offset;
            modelParticleRenderState.add(class_12249.method_75972(), (float)(this.field_3874 + offset.field_1352), (float)(this.field_3854 + offset.field_1351), (float)(this.field_3871 + offset.field_1350), quaternionf.x, quaternionf.y, quaternionf.z, quaternionf.w, this.method_18132(f), this.field_62633, this.field_62634, this.field_62635, this.field_62636, this.method_3068(f), this.model);
        }

        protected void method_60375(class_11944 quadParticleRenderState, Quaternionf rot, float x, float y, float z, float f) {
            class_243 offset = this.type.offset;
            super.method_60375(quadParticleRenderState, rot, (float)((double)x + offset.field_1352), (float)((double)y + offset.field_1351), (float)((double)z + offset.field_1350), f);
        }

        protected int method_3068(float partialTick) {
            int total = super.method_3068(partialTick);
            if (this.type.lightLevel > 0) {
                int sky = class_765.method_24187((int)total);
                int block = class_765.method_24186((int)total);
                block = Math.max(block, this.type.lightLevel);
                return class_765.method_23687((int)block, (int)sky);
            }
            return total;
        }

        public void method_3085() {
            super.method_3085();
            this.field_3866 = this.field_3847;
        }

        public void method_3070() {
            class_2680 state;
            boolean isTickTime;
            if (!this.type.isValid) {
                this.method_3085();
                return;
            }
            if (this.spriteSet != null) {
                this.method_74306(this.spriteSet);
            }
            super.method_3070();
            this.field_62638 = this.field_62637;
            this.oQuadSize = this.field_17867;
            boolean bl = isTickTime = this.field_3866 % this.type.tickRate == 0;
            if (this.type.ticker != null && isTickTime) {
                this.type.ticker.tick(this, this.field_3851);
            }
            if (this.type.colormap != null) {
                class_2338 pos = class_2338.method_49637((double)this.field_3874, (double)this.field_3854, (double)this.field_3871);
                float[] unpack = ColorUtils.unpack(this.type.colormap.getColor(null, (class_1920)this.field_3851, pos, 0));
                this.method_74305(unpack[0], unpack[1], unpack[2]);
            }
            if (this.field_3866 > 1 && this.type.killWhenStill && this.field_3874 == this.field_3858 && this.field_3854 == this.field_3838 && this.field_3871 == this.field_3856) {
                this.method_3085();
            }
            if (this.liquidAffinity != LiquidAffinity.ANY && this.liquidAffinity == LiquidAffinity.LIQUIDS ^ !(state = this.field_3851.method_8320(class_2338.method_49637((double)this.field_3874, (double)this.field_3854, (double)this.field_3871))).method_26227().method_15769()) {
                this.method_3085();
            }
            if (!this.field_3843 && isTickTime) {
                for (ParticleTickable tickable : this.tickables) {
                    tickable.tick((class_703)this, (class_1937)this.field_3851);
                }
            }
        }

        public void method_3069(double x, double y, double z) {
            class_243 wantedPos;
            class_243 myPos;
            super.method_3069(x, y, z);
            if (this.type.killOnContact && this.field_3866 > 1 && (myPos = new class_243(this.field_3874, this.field_3854, this.field_3871)).method_1025(wantedPos = new class_243(this.field_3858 + x, this.field_3838 + y, this.field_3856 + z)) > 1.0E-6) {
                this.method_3085();
                this.field_3852 = 0.0;
                this.field_3869 = 0.0;
                this.field_3850 = 0.0;
            }
        }

        public float method_18132(float scaleFactor) {
            return class_3532.method_16439((float)scaleFactor, (float)this.oQuadSize, (float)this.field_17867);
        }

        protected class_3940.class_11941 method_74255() {
            return this.type.getRenderType().getLayer(this.model != null);
        }

        public class_3999 method_74274() {
            return this.type.getParticleGroup();
        }
    }
}

