/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.content.particle.custom;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.mehvahdjukaar.polytone.PlatStuff;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.SpecialModelsHandler;
import net.mehvahdjukaar.polytone.common.Parsed;
import net.mehvahdjukaar.polytone.common.reloader.JsonPartialReloader;
import net.mehvahdjukaar.polytone.common.struc.MapRegistry;
import net.mehvahdjukaar.polytone.content.particle.ParticleParticleEmitter;
import net.mehvahdjukaar.polytone.content.particle.custom.CustomOrSemiCustomParticleCodec;
import net.mehvahdjukaar.polytone.content.particle.custom.CustomParticleFactory;
import net.mehvahdjukaar.polytone.content.particle.custom.CustomParticleType;
import net.mehvahdjukaar.polytone.content.particle.custom.ExtraDataParticleOptions;
import net.mehvahdjukaar.polytone.content.particle.custom.OverridingParticleFactory;
import net.mehvahdjukaar.polytone.content.particle.custom.SemiCustomParticleType;
import net.minecraft.class_11939;
import net.minecraft.class_2396;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_4002;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_707;
import net.minecraft.class_7225;
import net.minecraft.class_7923;

public class CustomParticlesManager
extends JsonPartialReloader {
    public final MapRegistry<CustomParticleFactory> customParticleFactories = new MapRegistry("Custom Particles");
    private final Map<class_2396<?>, class_707<?>> overwrittenVanillaProviders = new HashMap();
    public static final Codec<CustomParticleFactory> CUSTOM_OR_SEMI_CUSTOM_CODEC = Codec.either(SemiCustomParticleType.CODEC, CustomParticleType.CODEC).xmap(e -> (CustomParticleFactory)e.map(Function.identity(), Function.identity()), p -> {
        Either either;
        if (p instanceof CustomParticleType) {
            CustomParticleType c = (CustomParticleType)p;
            either = Either.right((Object)c);
        } else {
            either = Either.left((Object)((SemiCustomParticleType)p));
        }
        return either;
    });

    public CustomParticlesManager() {
        super("custom_particles");
    }

    @Override
    public void earlyProcess(class_3302.class_11558 sharedState) {
        class_3300 resourceManager = sharedState.method_72361();
        Map<class_2960, JsonElement> jsons = this.getJsonsInDirectories(resourceManager);
        for (Map.Entry<class_2960, JsonElement> j : jsons.entrySet()) {
            JsonElement json = j.getValue();
            class_2960 id = j.getKey();
            Optional model = (Optional)((Pair)CustomParticleType.CUSTOM_MODEL_ONLY_CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(errorMsg -> new IllegalStateException("Could not decode Custom Particle with json id " + String.valueOf(id) + "\n error: " + errorMsg))).getFirst();
            model.ifPresent(SpecialModelsHandler::addSpecialModel);
        }
    }

    @Override
    protected void resetWithLevel(boolean isLogOff) {
        for (class_2960 class_29602 : this.customParticleFactories.orderedKeys()) {
            CustomParticleFactory p = this.customParticleFactories.getValue(class_29602);
            if (p instanceof CustomParticleType) {
                CustomParticleType cp = (CustomParticleType)p;
                cp.setUnregistered();
            }
            PlatStuff.unregisterParticleProvider(class_29602);
            PlatStuff.unregisterDynamic(class_7923.field_41180, class_29602);
        }
        this.customParticleFactories.clear();
        for (Map.Entry entry : this.overwrittenVanillaProviders.entrySet()) {
            PlatStuff.setParticleProvider((class_2396)entry.getKey(), (class_707)entry.getValue());
        }
        this.overwrittenVanillaProviders.clear();
    }

    public void addSpriteSets(class_3300 resourceManager) {
        class_11939 resources = class_310.method_1551().field_1713.field_62618;
        for (class_2960 object : this.customParticleFactories.keySet()) {
        }
        Map<class_2960, JsonElement> jsons = this.getJsonsInDirectories(resourceManager);
        for (class_2960 v : jsons.keySet()) {
            resources.field_62627.put(v, new class_11939.class_4090());
        }
    }

    @Override
    protected void applyWithLevel(class_7225.class_7874 access, boolean isLogIn) {
    }

    @Override
    protected void parseWithLevel(Map<class_2960, JsonElement> jsons, class_6903<JsonElement> ops, class_7225.class_7874 access) {
        class_2960 id;
        CustomParticleFactory factory;
        class_11939 particleResources = class_310.method_1551().field_1713.field_62618;
        HashSet<CustomParticleType> customTypes = new HashSet<CustomParticleType>();
        for (Map.Entry<class_2960, CustomParticleFactory> entry : Parsed.batchParseOnlyEnabled(jsons, CustomOrSemiCustomParticleCodec.INSTANCE, ops, "custom particle")) {
            try {
                factory = entry.getValue();
                id = entry.getKey();
                factory.setSpriteSet((class_4002)particleResources.field_62627.get(id));
                if (factory instanceof CustomParticleType) {
                    CustomParticleType c = (CustomParticleType)factory;
                    customTypes.add(c);
                }
                if (class_7923.field_41180.method_10223(id).isPresent()) {
                    class_2396 oldType = (class_2396)((class_6880.class_6883)class_7923.field_41180.method_10223(id).get()).comp_349();
                    Polytone.LOGGER.info("Overriding particle with id {}", (Object)id);
                    class_707<?> oldFactory = PlatStuff.getParticleProvider(oldType);
                    this.overwrittenVanillaProviders.put(oldType, oldFactory);
                    try {
                        particleResources.method_74300(oldType, new OverridingParticleFactory(factory));
                    }
                    catch (Exception e) {
                        Polytone.LOGGER.error("Can't override existing particle with ID {}. Particle type not supported", (Object)id, (Object)e);
                    }
                    continue;
                }
                this.customParticleFactories.register(id, factory);
                Polytone.LOGGER.info("Registered Custom Particle {}", (Object)id);
            }
            catch (Exception e) {
                Polytone.LOGGER.error("!!!!!!!!!!!! Failed to load Custom Particle {}", (Object)entry.getKey(), (Object)e);
            }
        }
        for (Map.Entry<class_2960, CustomParticleFactory> entry : this.customParticleFactories.getEntries()) {
            factory = entry.getValue();
            id = entry.getKey();
            class_2396<ExtraDataParticleOptions> type = PlatStuff.makeParticleType(factory.forceSpawns());
            PlatStuff.registerDynamic(class_7923.field_41180, id, type);
            particleResources.method_74300(type, (class_707)factory);
        }
        for (CustomParticleType customParticleType : customTypes) {
            if (customParticleType.lazyParticles == null) continue;
            for (Dynamic<?> d : customParticleType.lazyParticles) {
                customParticleType.particles.add(CustomParticlesManager.runCodec(ops, d));
            }
            customParticleType.lazyParticles = null;
        }
    }

    private static <T> ParticleParticleEmitter runCodec(DynamicOps o, Dynamic<T> dynamic) {
        DynamicOps ops = o;
        return (ParticleParticleEmitter)((Pair)ParticleParticleEmitter.CODEC.decode(ops, dynamic.getValue()).getOrThrow()).getFirst();
    }

    public Codec<CustomParticleFactory> byNameCodec() {
        return this.customParticleFactories;
    }

    public boolean isDynamicParticle(class_2960 entryId) {
        return this.customParticleFactories.containsKey(entryId);
    }
}

