/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.content.particle.custom;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.mehvahdjukaar.polytone.common.codec.CodecUtils;
import net.mehvahdjukaar.polytone.common.expressions.impl.IParticleExp;
import net.mehvahdjukaar.polytone.content.particle.custom.RotationMode;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_3940;
import net.minecraft.class_4184;
import net.minecraft.class_638;
import net.minecraft.class_703;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;

public interface RotationProvider
extends class_3940.class_8981 {
    public static final Codec<RotationProvider> CODEC = CodecUtils.withAlternative(CustomRotation.CODEC, RotationMode.CODEC);

    public boolean alwaysFacesCamera();

    public void setRotation(@Nullable class_3940 var1, Quaternionf var2, class_4184 var3, float var4);

    default public void setRotation(Quaternionf quaternionf, class_4184 camera, float f) {
        this.setRotation(null, quaternionf, camera, f);
    }

    public record CustomRotation(IParticleExp xRot, IParticleExp yRot, IParticleExp zRot) implements RotationProvider
    {
        public static final Codec<CustomRotation> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)IParticleExp.CODEC.optionalFieldOf("x_rot", (Object)IParticleExp.ZERO).forGetter(CustomRotation::xRot), (App)IParticleExp.CODEC.optionalFieldOf("y_rot", (Object)IParticleExp.ZERO).forGetter(CustomRotation::yRot), (App)IParticleExp.CODEC.optionalFieldOf("z_rot", (Object)IParticleExp.ZERO).forGetter(CustomRotation::zRot)).apply((Applicative)instance, CustomRotation::new));

        @Override
        public boolean alwaysFacesCamera() {
            return false;
        }

        @Override
        public void setRotation(@Nullable class_3940 particle, Quaternionf quaternionf, class_4184 camera, float partialTicks) {
            if (particle == null) {
                return;
            }
            class_638 level = class_310.method_1551().field_1687;
            double x = this.xRot.evaluate((class_703)particle, (class_1937)level);
            double y = this.yRot.evaluate((class_703)particle, (class_1937)level);
            double z = this.zRot.evaluate((class_703)particle, (class_1937)level);
            quaternionf.rotateXYZ((float)x, (float)y, (float)z);
        }
    }
}

