/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.content.slotify;

import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.common.Parsed;
import net.mehvahdjukaar.polytone.common.reloader.JsonPartialReloader;
import net.mehvahdjukaar.polytone.content.slotify.GuiModifier;
import net.mehvahdjukaar.polytone.content.slotify.ScreenModifier;
import net.mehvahdjukaar.polytone.content.slotify.SlotModifier;
import net.minecraft.class_1703;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3917;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_481;
import net.minecraft.class_490;
import net.minecraft.class_5250;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7417;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class GuiModifierManager
extends JsonPartialReloader {
    private final Map<class_3917<?>, Set<SlotModifier>> slotsByMenuId = new IdentityHashMap();
    private final Map<Class<?>, Set<SlotModifier>> slotsByClass = new IdentityHashMap();
    private final Map<String, Set<SlotModifier>> slotsByTitle = new HashMap<String, Set<SlotModifier>>();
    public final Map<class_3917<?>, ScreenModifier> byMenuId = new IdentityHashMap();
    public final Map<Class<?>, ScreenModifier> byClass = new IdentityHashMap();
    public final Map<String, ScreenModifier> byTitle = new HashMap<String, ScreenModifier>();
    private static final class_2960 INVENTORY = class_2960.method_60654((String)"inventory");

    public GuiModifierManager() {
        super("gui_modifiers");
    }

    @Override
    protected void resetWithLevel(boolean logOff) {
        this.slotsByMenuId.clear();
        this.slotsByClass.clear();
        this.slotsByTitle.clear();
        this.byMenuId.clear();
        this.byClass.clear();
        this.byTitle.clear();
    }

    @Override
    protected void parseWithLevel(Map<class_2960, JsonElement> jsons, class_6903<JsonElement> ops, class_7225.class_7874 access) {
        ArrayList<GuiModifier> allModifiers = new ArrayList<GuiModifier>();
        for (Map.Entry<class_2960, GuiModifier> entry : Parsed.batchParseOnlyEnabled(jsons, GuiModifier.CODEC, ops, "gui modifier")) {
            allModifiers.add(entry.getValue());
        }
        for (GuiModifier mod : allModifiers) {
            if (mod.targetsClass()) {
                String target = mod.target();
                try {
                    Class cl = target.equals("InventoryMenu") ? class_1723.class : (target.equals("ItemPickerMenu") ? class_481.class_483.class : Class.forName(target));
                    this.byClass.merge(cl, ScreenModifier.fromGuiMod(mod), ScreenModifier::merge);
                    if (mod.slotModifiers().isEmpty()) continue;
                    Set map = this.slotsByClass.computeIfAbsent(cl, i -> new HashSet());
                    map.addAll(mod.slotModifiers());
                }
                catch (ClassNotFoundException ignored) {
                    Polytone.LOGGER.error("Could not find class target with name {}", (Object)target);
                }
                continue;
            }
            if (mod.targetsMenuId()) {
                class_2960 menuId = class_2960.method_60654((String)mod.target());
                boolean isInventory = menuId.equals((Object)INVENTORY);
                Optional menu = class_7923.field_41187.method_17966(menuId);
                if (!menu.isPresent() && !isInventory) continue;
                this.byMenuId.merge(menu.orElse(null), ScreenModifier.fromGuiMod(mod), ScreenModifier::merge);
                if (mod.slotModifiers().isEmpty()) continue;
                Set map = this.slotsByMenuId.computeIfAbsent(menu.orElse(null), i -> new HashSet());
                map.addAll(mod.slotModifiers());
                continue;
            }
            String title = mod.target();
            this.byTitle.merge(title, ScreenModifier.fromGuiMod(mod), ScreenModifier::merge);
            if (mod.slotModifiers().isEmpty()) continue;
            Set map = this.slotsByTitle.computeIfAbsent(title, i -> new HashSet());
            map.addAll(mod.slotModifiers());
        }
    }

    @Override
    protected void applyWithLevel(class_7225.class_7874 access, boolean isLogIn) {
        if (!(this.slotsByMenuId.isEmpty() && this.slotsByClass.isEmpty() && this.slotsByTitle.isEmpty())) {
            Polytone.LOGGER.info("Loaded GUI modifiers for: {} {} {} {}", this.slotsByMenuId.keySet(), this.slotsByClass.keySet(), this.byMenuId.keySet(), this.byClass.keySet());
        }
    }

    private ScreenModifier getScreenModifier(class_465<?> screen) {
        ScreenModifier m = null;
        class_1703 menu = screen.method_17577();
        if (screen.getClass() == class_490.class) {
            m = this.byClass.get(class_1723.class);
        } else if (screen.getClass() == class_481.class) {
            m = this.byClass.get(class_481.class_483.class);
        }
        if (menu != null) {
            m = this.byClass.get(menu.getClass());
        }
        if (m == null) {
            class_3917 type;
            try {
                type = menu.method_17358();
            }
            catch (Exception e) {
                type = null;
            }
            m = this.byMenuId.get(type);
        }
        return m;
    }

    @Nullable
    public ScreenModifier getGuiModifier(class_437 screen) {
        class_5250 mc;
        class_7417 class_74172;
        class_2561 c;
        ScreenModifier m = this.byClass.get(screen.getClass());
        if (m == null && screen instanceof class_465) {
            class_465 as = (class_465)screen;
            m = this.getScreenModifier(as);
        }
        try {
            c = screen.method_25440();
        }
        catch (Exception e) {
            return null;
        }
        if (m == null) {
            m = this.byTitle.get(c.getString());
        }
        if (m == null && c instanceof class_5250 && (class_74172 = (mc = (class_5250)c).method_10851()) instanceof class_2588) {
            class_2588 tc = (class_2588)class_74172;
            m = this.byTitle.get(tc.method_11022());
        }
        return m;
    }

    public Collection<SlotModifier> getSlotModifiers(class_465<?> screen, class_1735 slot) {
        class_5250 mc;
        class_7417 class_74172;
        class_2561 c = screen.method_25440();
        Set<SlotModifier> modifies = this.slotsByTitle.get(c.getString());
        if (modifies == null && c instanceof class_5250 && (class_74172 = (mc = (class_5250)c).method_10851()) instanceof class_2588) {
            class_2588 tc = (class_2588)class_74172;
            modifies = this.slotsByTitle.get(tc.method_11022());
        }
        if (modifies == null) {
            modifies = this.slotsByClass.get(screen.getClass());
        }
        if (modifies == null) {
            this.slotsByClass.get(screen.method_17577().getClass());
        }
        if (modifies == null) {
            class_3917 type;
            try {
                type = screen.method_17577().method_17358();
            }
            catch (Exception e) {
                type = null;
            }
            modifies = this.slotsByMenuId.get(type);
        }
        if (modifies != null) {
            return modifies.stream().filter(m -> m.matches(slot)).toList();
        }
        return Set.of();
    }

    public Collection<SlotModifier> getSlotModifiers(class_1703 menu, class_1735 slot) {
        Set<SlotModifier> modifiers = this.slotsByClass.get(menu.getClass());
        if (modifiers == null) {
            class_3917 type;
            try {
                type = menu.method_17358();
            }
            catch (Exception e) {
                type = null;
            }
            modifiers = this.slotsByMenuId.get(type);
        }
        if (modifiers != null) {
            return modifiers.stream().filter(m -> m.matches(slot)).toList();
        }
        return Set.of();
    }

    public void maybeModifySlot(class_1703 menu, class_1735 slot) {
        Collection<SlotModifier> mods = this.getSlotModifiers(menu, slot);
        for (SlotModifier mod : mods) {
            if (!mod.matches(slot)) continue;
            mod.modify(slot);
        }
    }
}

