/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.content.tabs;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.mehvahdjukaar.polytone.PlatStuff;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.common.Targets;
import net.mehvahdjukaar.polytone.common.codec.CodecUtils;
import net.mehvahdjukaar.polytone.common.struc.ListUtils;
import net.mehvahdjukaar.polytone.content.tabs.ItemAddition;
import net.mehvahdjukaar.polytone.content.tabs.ItemPredicate;
import net.mehvahdjukaar.polytone.content.tabs.ItemToTabEvent;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_8824;

public record CreativeTabModifier(Optional<class_1799> icon, Optional<Boolean> search, Optional<Integer> searchWidth, Optional<Boolean> canScroll, Optional<Boolean> showTitle, Optional<class_2561> name, Optional<class_2960> backGroundLocation, Optional<class_2960> tabsImage, Optional<List<class_2960>> beforeTabs, Optional<List<class_2960>> afterTabs, List<ItemPredicate> removals, List<ItemAddition> additions, boolean registerTab, Targets targets) {
    public static final Codec<CreativeTabModifier> CODEC = RecordCodecBuilder.create(i -> i.group((App)CodecUtils.ITEM_OR_STACK.optionalFieldOf("icon").forGetter(CreativeTabModifier::icon), (App)Codec.BOOL.optionalFieldOf("search_bar").forGetter(CreativeTabModifier::search), (App)Codec.INT.optionalFieldOf("search_bar_width").forGetter(CreativeTabModifier::searchWidth), (App)Codec.BOOL.optionalFieldOf("can_scroll").forGetter(CreativeTabModifier::canScroll), (App)Codec.BOOL.optionalFieldOf("show_title").forGetter(CreativeTabModifier::showTitle), (App)class_8824.field_46597.optionalFieldOf("name").forGetter(CreativeTabModifier::name), (App)class_2960.field_25139.optionalFieldOf("background").forGetter(CreativeTabModifier::backGroundLocation), (App)class_2960.field_25139.optionalFieldOf("tabs_image").forGetter(CreativeTabModifier::tabsImage), (App)class_2960.field_25139.listOf().optionalFieldOf("before_tabs").forGetter(CreativeTabModifier::beforeTabs), (App)class_2960.field_25139.listOf().optionalFieldOf("after_tabs").forGetter(CreativeTabModifier::afterTabs), (App)ItemPredicate.CODEC.listOf().optionalFieldOf("removals", List.of()).forGetter(CreativeTabModifier::removals), (App)ItemAddition.CODEC.listOf().optionalFieldOf("additions", List.of()).forGetter(CreativeTabModifier::additions), (App)Codec.BOOL.optionalFieldOf("create_new", (Object)false).forGetter(CreativeTabModifier::registerTab), (App)Targets.CODEC.optionalFieldOf("targets", (Object)Targets.EMPTY).forGetter(CreativeTabModifier::targets)).apply((Applicative)i, CreativeTabModifier::new)).validate(m -> {
        if (m.registerTab && (!m.removals.isEmpty() || m.targets != Targets.EMPTY)) {
            return DataResult.error(() -> "Modifiers that register new creative tabs cannot have item removals or target existing tabs.");
        }
        return DataResult.success((Object)m);
    });

    public CreativeTabModifier merge(CreativeTabModifier newMod) {
        return new CreativeTabModifier(newMod.icon.isPresent() ? newMod.icon : this.icon, newMod.search.isPresent() ? newMod.search : this.search, newMod.searchWidth.isPresent() ? newMod.searchWidth : this.searchWidth, newMod.canScroll.isPresent() ? newMod.canScroll : this.canScroll, newMod.showTitle.isPresent() ? newMod.showTitle : this.showTitle, newMod.name.isPresent() ? newMod.name : this.name, newMod.backGroundLocation.isPresent() ? newMod.backGroundLocation : this.backGroundLocation, newMod.tabsImage.isPresent() ? newMod.tabsImage : this.tabsImage, newMod.beforeTabs.isPresent() ? newMod.beforeTabs : this.beforeTabs, newMod.afterTabs.isPresent() ? newMod.afterTabs : this.afterTabs, ListUtils.mergeList(newMod.removals, this.removals), ListUtils.mergeList(newMod.additions, this.additions), this.registerTab || newMod.registerTab, this.targets.merge(newMod.targets));
    }

    public CreativeTabModifier applyItemsAndAttributes(ItemToTabEvent event, class_7225.class_7874 access) {
        for (ItemPredicate itemPredicate : this.removals) {
            event.removeItems(itemPredicate);
        }
        for (ItemAddition itemAddition : this.additions) {
            List<class_1799> stacks = itemAddition.items().get();
            if (stacks == null) continue;
            if (itemAddition.inverse()) {
                ArrayList<class_1799> newList = new ArrayList<class_1799>();
                List<class_1792> not = stacks.stream().map(class_1799::method_7909).toList();
                for (class_1792 i : class_7923.field_41178) {
                    if (not.contains(i)) continue;
                    newList.add(i.method_7854());
                }
                stacks = newList;
            }
            if (itemAddition.before()) {
                event.addBefore((Predicate<class_1799>)itemAddition.predicate(), (class_1799[])stacks.toArray(class_1799[]::new));
                continue;
            }
            event.addAfter((Predicate<class_1799>)itemAddition.predicate(), (class_1799[])stacks.toArray(class_1799[]::new));
        }
        return this.applyAttributes(event.getTab());
    }

    public CreativeTabModifier applyAttributes(class_5321<class_1761> key) {
        Optional tab = class_7923.field_44687.method_46746(key);
        if (tab.isEmpty()) {
            Polytone.LOGGER.error("Could not find creative mode tab with ID {}. What?", key);
        }
        return PlatStuff.modifyTab(this, (class_1761)((class_6880.class_6883)tab.get()).comp_349());
    }
}

