/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.content.texture;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import java.util.Locale;
import net.mehvahdjukaar.polytone.common.ClientFrameTicker;
import net.mehvahdjukaar.polytone.common.codec.CodecUtils;
import net.mehvahdjukaar.polytone.common.expressions.ExpTicker;
import net.mehvahdjukaar.polytone.common.expressions.impl.ISimpleExp;
import net.minecraft.class_12131;
import net.minecraft.class_12206;
import net.minecraft.class_310;
import net.minecraft.class_3542;
import net.minecraft.class_638;
import org.jetbrains.annotations.Nullable;

public interface IDayTimeContext {
    public ITextureDeltaProvider polytone$getDeltaProvider();

    public void polytone$setDeltaProvider(ITextureDeltaProvider var1);

    public int polytone$getTimeCycleDuration();

    public void polytone$setTimeCycleDuration(int var1);

    public static enum PolyDeltaProvider implements class_3542,
    ITextureDeltaProvider
    {
        VANILLA,
        GAME_TIME,
        DAY_TIME,
        WEATHER,
        SCREEN_TIME,
        MOON_PHASE;

        public static final Codec<PolyDeltaProvider> CODEC;

        public String method_15434() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public static PolyDeltaProvider byName(String name) {
            try {
                return PolyDeltaProvider.valueOf(name.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                return VANILLA;
            }
        }

        public static PolyDeltaProvider get(@Nullable JsonElement json) {
            if (json != null && json.isJsonPrimitive()) {
                return PolyDeltaProvider.byName(json.getAsString());
            }
            return VANILLA;
        }

        @Override
        @Nullable
        public Float getDelta(float timeCycleDuration) {
            class_638 level = class_310.method_1551().field_1687;
            if (level == null) {
                return null;
            }
            return switch (this.ordinal()) {
                case 3 -> {
                    float rainAndThunder = ExpTicker.getRainAndThunder() * 2.0f / 3.0f;
                    yield Float.valueOf(rainAndThunder + 0.0f);
                }
                case 1 -> {
                    double gameTime = (float)level.method_75260() % timeCycleDuration;
                    yield Float.valueOf((float)(gameTime / (double)timeCycleDuration));
                }
                case 5 -> {
                    int phase = ((class_12131)level.method_75728().method_75694(class_12206.field_64343)).method_75261();
                    yield Float.valueOf((float)phase / 8.0f);
                }
                case 4 -> Float.valueOf(Math.min(1.0f, (float)ExpTicker.getGuiTime() / timeCycleDuration));
                default -> {
                    double dayTime = ClientFrameTicker.getDayTime() % (double)timeCycleDuration;
                    yield Float.valueOf((float)(dayTime / (double)timeCycleDuration));
                }
            };
        }

        static {
            CODEC = class_3542.method_28140(PolyDeltaProvider::values);
        }
    }

    public record ExpressionDeltaProvider(ISimpleExp exp) implements ITextureDeltaProvider
    {
        public static final Codec<ExpressionDeltaProvider> CODEC = ISimpleExp.CODEC.xmap(ExpressionDeltaProvider::new, ExpressionDeltaProvider::exp);

        @Override
        public Float getDelta(float timeCycleDuration) {
            return Float.valueOf((float)this.exp.evaluate());
        }
    }

    public static interface ITextureDeltaProvider {
        public static final Codec<ITextureDeltaProvider> CODEC = CodecUtils.withAlternative(PolyDeltaProvider.CODEC, ExpressionDeltaProvider.CODEC);

        @Nullable
        public Float getDelta(float var1);
    }
}

